#include "mbed.h"
#include "functions.h"

LCD_DISCO_F469NI lcd;
SD_DISCO_F469NI sd;
Serial pc(USBTX, USBRX);
AnalogIn speed_value(A0);
DigitalIn changescreen_command(D0);
DigitalIn brake(D1);

float Vin;
extern GEAR *Gears;
extern IMAGE LogoBig,LogoSmall,Branko;

void MainScreen();
void FirstAuxScreen();
void SecondAuxScreen();

int main(){
    DrawRGBImage(LogoBig,0,0);
    wait(0.5);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0,0,800,480);
    MainScreen();
};
    
    
void MainScreen(){
    lcd.SetTextColor(LCD_COLOR_BLACK);
    DrawSpeedMeter();
    DrawRGBImage(LogoSmall,LogoSmallXPos,LogoSmallYPos);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(30,170,(uint8_t*)"Oil Temp",LEFT_MODE);
    lcd.DisplayStringAt(30,320,(uint8_t*)"Water Temp",LEFT_MODE);
    lcd.DisplayStringAt(584,170,(uint8_t*)"TPS",LEFT_MODE);
    lcd.SetTextColor(LCD_COLOR_DARKRED);
    lcd.FillRect(560,340,230,68);
    lcd.SetBackColor(LCD_COLOR_DARKRED);
    PrintString("BRAKE",50,575,350,LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    uint8_t V0=0;
    int gear=1;
    int brake0;
    while(changescreen_command.read()==0){
        Vin=(int)(speed_value.read()*150);
        UpdateSpeedMeter(V0,Vin-V0);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        ChangeNumber(Vin,V0,100,OilTempXPos,OilTempYPos);
        ChangeNumber(Vin,V0,100,WaterTempXPos,WaterTempYPos);
        ChangeNumber(Vin,V0,100,TPSXPos,TPSYPos);
        BrakeSignal(brake.read(),brake0);
        V0=Vin;
        brake0=brake;
        if (Vin==0 & gear!=0){
            PrintChar(Gears[0],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=0;
        } else if (Vin>0 & Vin<=20 & gear!=1){
            PrintChar(Gears[1],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=1;
        } else if (Vin>20 & Vin<=40 & gear!=2){
            PrintChar(Gears[2],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=2;
        } else if (Vin>40 & Vin<=60 & gear!=3){
            PrintChar(Gears[3],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=3;
        } else if (Vin>60 & Vin<=80 & gear!=4){
            PrintChar(Gears[4],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=4;
        } else if (Vin>80 & Vin<=100 & gear!=5){
            PrintChar(Gears[5],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=5;
        } else if (Vin>100 & gear!=6){
            PrintChar(Gears[6],GearXPos,GearYPos,LCD_COLOR_BLACK);
            gear=6;
        };
    };
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0,0,800,480);
    FirstAuxScreen();
    lcd.SetTextColor(LCD_COLOR_BLACK);
};

void FirstAuxScreen(){
    PrintString("Oil P",50,20,25,LCD_COLOR_BLACK);
    PrintString("MAP",50,20,100,LCD_COLOR_BLACK);
    PrintString("Air Temp",50,20,175,LCD_COLOR_BLACK);
    PrintString("Lambda",50,20,250,LCD_COLOR_BLACK);
    PrintString("Volts",50,20,325,LCD_COLOR_BLACK);
    PrintString("Crank",50,20,400,LCD_COLOR_BLACK);
    PrintString("kPa",50,470,25,LCD_COLOR_BLACK);
    PrintString("kPa",50,470,100,LCD_COLOR_BLACK);
    PrintString("C",50,470,175,LCD_COLOR_BLACK);
    PrintString("Ratio",50,470,250,LCD_COLOR_BLACK);
    PrintString("V",50,470,325,LCD_COLOR_BLACK);
    DrawRGBImage(LogoSmall,LogoSmallXPos,LogoSmallYPos);
    int V0=0;
    while(changescreen_command.read()==0){
        Vin=(int)(speed_value.read()*150);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        ChangeNumber(Vin,V0,50,OilPXPos,OilPYPos);
        ChangeNumber(Vin,V0,50,MAPXPos,MAPYPos);
        ChangeNumber(Vin,V0,50,AirTempXPos,AirTempYPos);
        ChangeNumber(Vin,V0,50,LambdaXPos,LambdaYPos);
        ChangeNumber(Vin,V0,50,VoltsXpos,VoltsYPos);
        if (Vin>100){
            PrintString("ERROR",50,CrankXPos,CrankYPos,LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
        } else {
            PrintString("             ",50,350,400,LCD_COLOR_GREEN);
            PrintString("OK",50,CrankXPos,CrankYPos,LCD_COLOR_GREEN);
            lcd.SetTextColor(LCD_COLOR_BLACK);
        };
        V0=Vin;
    };
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0,0,800,480);
    SecondAuxScreen();

};

void SecondAuxScreen(){
    PrintString("LVDT Sensors",50,200,20,LCD_COLOR_BLACK);
    DrawRGBImage(LogoSmall,LogoSmallXPos,LogoSmallYPos);
    int V0=0;
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(FLLVDTBarXPos+25,FLLVDTBarYPos,(uint8_t*)"FL",LEFT_MODE);
    lcd.DisplayStringAt(FRLVDTBarXPos+25,FRLVDTBarYPos,(uint8_t*)"FR",LEFT_MODE);
    lcd.DisplayStringAt(BLLVDTBarXPos+25,BLLVDTBarYPos,(uint8_t*)"BL",LEFT_MODE);
    lcd.DisplayStringAt(BRLVDTBarXPos+25,BRLVDTBarYPos,(uint8_t*)"BR",LEFT_MODE);
    
    while(changescreen_command.read()==0){
        Vin=(int)(speed_value.read()*150);
        ChangeNumber(Vin,V0,100,FLLVDTXPos,FLLVDTYPos);
        ChangeNumber(Vin,V0,100,FRLVDTXPos,FRLVDTYPos);
        ChangeNumber(Vin,V0,100,BLLVDTXPos,BLLVDTYPos);
        ChangeNumber(Vin,V0,100,BRLVDTXPos,BRLVDTYPos);
        UpdateLVDTScale(Vin,V0,FLLVDTBarXPos,FLLVDTBarYPos);
        UpdateLVDTScale(Vin,V0,FRLVDTBarXPos,FRLVDTBarYPos);
        UpdateLVDTScale(Vin,V0,BLLVDTBarXPos,BLLVDTBarYPos);
        UpdateLVDTScale(Vin,V0,BRLVDTBarXPos,BRLVDTBarYPos);
        V0=Vin;
        };
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0,0,800,480);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    MainScreen();
};