/*
Author: foreste
Program name: control led action
Platform test hardware: Stm32f0RB and Atnel.pl ATB 1,04A
Forum: http://microgeek.eu/
*/

#include "mbed.h"

//Settings Uart
Serial rs232(USBTX, USBRX);

//Setting pins
DigitalOut led[8] {PC_3, PC_2, PA_1, PA_0, PA_15, PC_12, PC_13, PB_7};

//Delay no blocking program
Timer delay;

char user_input = 0; //user variable

//fuction replace state pin in High
void ledintilize()
{
    for(int x=0; x<8; x++) {
        led[x] = 1;
    }
}

//fuction replace state pin in High special method 
void pin_clear_state()
{
    led[0] = led[1] = led[2] = led[3] = led[4] = led[5] = led[6] = led[7] = 1;
}
//first method flashing knight
void led_knight()
{
    switch(delay.read_ms()) {
        case 500:
            pin_clear_state();
            led[0] = 0;
            break;
        case 1000:
            led[0] = 1;
            led[1] = 0;
            break;
        case 1500:
            led[1] = 1;
            led[2] = 0;
            break;
        case 2000:
            led[2] = 1;
            led[3] = 0;
            break;
        case 2500:
            led[3] = 1;
            led[4] = 0;
            break;
        case 3000:
            led[4] = 1;
            led[5] = 0;
            break;
        case 3500:
            led[5] = 1;
            led[6] = 0;
            break;
        case 4000:
            led[6] = 1;
            led[7] = 0;
            break;
        case 4500:
            led[7] = 1;
            delay.reset();
            break;
    }
}
// second method flashing knight
void led_knight2()
{
    switch(delay.read_ms()) {
        case 500:
            pin_clear_state();
            led[0] = 0;
            break;
        case 1000:
            led[0] = 1;
            led[1] = 0;
            break;
        case 1500:
            led[1] = 1;
            led[2] = 0;
            break;
        case 2000:
            led[2] = 1;
            led[3] = 0;
            break;
        case 2500:
            led[3] = 1;
            led[4] = 0;
            break;
        case 3000:
            led[4] = 1;
            led[5] = 0;
            break;
        case 3500:
            led[5] = 1;
            led[6] = 0;
            break;
        case 4000:
            led[6] = 1;
            led[7] = 0;
            break;
        case 4500:
            led[7] = 1;
            break;

        case 5000:
            led[7] = 1;
            led[6] = 0;
            break;
        case 5500:
            led[6] = 1;
            led[5] = 0;
            break;
        case 6000:
            led[5] = 1;
            led[4] = 0;
            break;
        case 6500:
            led[4] = 1;
            led[3] = 0;
            break;
        case 7000:
            led[3] = 1;
            led[2] = 0;
            break;
        case 7500:
            led[2] = 1;
            led[1] = 0;
            break;
        case 8000:
            led[1] = 1;
            led[0] = 0;
            break;
        case 8500:
            led[0] = 1;
            delay.reset();
            break;
    }

}

//Third method flashing knight
void  knight3()
{
    switch(delay.read_ms()) {
        case 500:
            pin_clear_state();
            // led[7] = 1;
            led[6] = 0;
            break;
        case 1000:
            led[6] = 1;
            led[5] = 0;
            break;
        case 1500:
            led[5] = 1;
            led[4] = 0;
            break;
        case 2000:
            led[4] = 1;
            led[3] = 0;
            break;
        case 25000:
            led[3] = 1;
            led[2] = 0;
            break;
        case 3000:
            led[2] = 1;
            led[1] = 0;
            break;
        case 35000:
            led[1] = 1;
            led[0] = 0;
            break;
        case 4000:
            led[0] = 1;
            delay.reset();
            break;
    }
}
//first method flashing Police sirens
void police_light()
{
    if(delay.read_ms() >= 200) {
        pin_clear_state();
        led[0] = led[1] = led[2] = led[3] = 0;
        if(delay.read_ms() >= 400) {
            led[0] = led[1] = led[2] = led[3] = 1;
            led[4] = led[5] = led[6] = led[7] = 0;
            delay.reset();
        }
    }
}

//Second method flashing Police sirens
void police_light2()
{
    if(delay.read_ms() >= 200) {
        pin_clear_state();
        led[0] = led[2] = led[4] = led[6] = 0;
        if(delay.read_ms() >= 400) {
            led[0] = led[2] = led[4] = led[6] = 1;
            led[1] = led[3] = led[5] = led[7] = 0;
            delay.reset();
        }
    }
}


//Fuction interruption uart 
void rs232in()
{
    if(rs232.readable()) {
        user_input = rs232.getc();
    }
}
int main()
{
    ledintilize(); //fuction replace state pin in High
    rs232.attach(&rs232in); //Fuction interruption uart 

    while(1) {


//Select mode flash light  for user
        switch(user_input) {


            case '1':

                delay.start();
                led_knight();
                break;
            case '2':

                delay.start();
                led_knight2();
                break;

            case '3':
                delay.start();
                knight3();
                break;

            case '4':
                delay.start();
                police_light();
                break;

            case '5':
                delay.start();
                police_light2();
                break;

        }
    }
}