#include "mbed.h"
#include "GPS.h"
#include "ESP8266.h"
#include "TextLCD.h"
#include "DS3231.h"

#define BUFFER_SIZE 100  

I2C i2c(D14,D15);
TextLCD_I2C lcd(&i2c,0x4E,TextLCD::LCD16x2);
DS3231 rtc(D14,D15);
Serial esp(D8, D2);  
Serial pc(USBTX, USBRX);  
GPS gps(PA_11, PA_12);
uint8_t buffer[0x100];  
uint16_t buffer_head;  
uint16_t buffer_tail;  

void rxcallback(void) {  
    uint8_t chr;  
    while (esp.readable()) {  
        chr = esp.getc();  
        pc.putc(chr);
        buffer[buffer_head++] = chr;  
        if (buffer_head == BUFFER_SIZE) 
        {  
            buffer_head = 0;  
        }  
    }  
}
void flush_fifo(void) 
{  
    while (esp.readable()) 
    {  
        (void)esp.getc();  
    }  
    buffer_head = 0;  
    buffer_tail = 0;  
}  
int find_response(const char *resp) {  
    /* Give some delay for buffer to fill up */  
    wait_ms(10);  
    int timeout = 0xFFFFFF;  
    int len = strlen(resp);  
    do 
    {  
        if (buffer_head > (buffer_tail + len)) 
        {  
            if (!memcmp(&buffer[buffer_tail], resp, len)) 
            {  
                flush_fifo();  
                return 0;  
            }  
            buffer_tail++;  
        }  
    }while(timeout--);  
    flush_fifo();  
    return 1;  
}

int main() 
{
    int h,m,s;
    char message[100];
    char ip[]="158.108.112.123";
    int port=80;
    char ap_name[]="FSE-Wireless";
    char password[]="1234567890";
    
    lcd.setMode(TextLCD::DispOn); 
    lcd.setBacklight(TextLCD::LightOff);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    //esp.attach(&rxcallback, Serial::RxIrq); 
    
    lcd.printf("Initial GPS...\n");
    
    //rtc.setTime(19,27,30);
    //initial wifi
    //esp.printf("AT+RST\r\n");
    //lcd.printf("AT+RST\n");
    //MBED_ASSERT(find_response("OK") == 0); 
    //esp.printf("AT+CWMODE=1\r\n");
    //lcd.printf("AT+CWMODE=1\n");
    //wait(2);  
    //flush_fifo();
    //esp.printf("AT+CWJAP=\"%s\",\"%s\"\r\n",ap_name,password);
    //lcd.printf("AT+CWJAP=\"%s\",\"%s\"\n",ap_name,password);
    //wait(10);
    //MBED_ASSERT(find_response("OK") == 0); 
    //esp.printf("AT+CIPMUX=0\r\n");
    //lcd.printf("AT+CIPMUX=0\n");
    //MBED_ASSERT(find_response("OK") == 0); 
    
    lcd.cls();
    while(1){
        rtc.readTime(&h,&m,&s);
        lcd.setAddress(0,0);
        lcd.printf("%02d:%02d:%02d",h,m,s);
        if(gps.sample())
        {
            lcd.setAddress(0,1);
            lcd.printf("%6.3f,%7.3f",gps.latitude,gps.longitude);
            //sprintf(message,"GET /gps.php?Lat=%f&Lon=%f",gps.latitude,gps.longitude);
            //esp.printf("AT+CIPSTART=\"TCP\",\"%s\",%s\r\n",ip,port);
            //esp.printf("AT+CIPSEND=0,%d\r\n",strlen(message));
            //if(find_response(">") == 0) 
            //{
            //    esp.printf(message);
            //}
            //wait(2);  
            //flush_fifo();
            //esp.printf("AT+CIPCLOSE\r\n");
            wait(0.5);  
            //flush_fifo();
                 
        }
    }
}
