#include "mbed.h"
#include "TextLCD.h"
#include "DS3231.h"
#include "RHT03.h"
//Incluye resistencias de 2.2K en los pines de i2c a 3.3
 


// I2C Communication
I2C i2c_lcd(D14,D15); // SDA, SCL
DS3231 ds3231(D14,D15);
RHT03 rht(D13);
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type 

int main() 
{
    lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
    lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn
    lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn
    //lcd.printf("Oscar de Jesus \n Vasquez");
    //ds3231.setTime(23,57,0);
    while(1)
    {
        int h,m,s;
        ds3231.readTime(&h,&m,&s);
        rht.readData();
        lcd.setAddress(0,0);
        lcd.printf("%02d:%02d:%02d",h,m,s);
        lcd.setAddress(0,1);
        lcd.printf("T:%.1f H:%.1f",rht.getTemperatureC(),rht.getHumidity());
        wait(1.0);
    }
 }