#include "mbed.h"
#include "TextLCD.h"
#include "DS3231.h"
#include "RHT03.h"
I2C i2c(D14,D15);
TextLCD_I2C lcd(&i2c,0x4E,TextLCD::LCD16x2);
DS3231 rtc(D14,D15);
RHT03 rht(D13);
DigitalOut p1(D3),p2(D4),p3(D5),p4(D6),p5(D7),p6(D9),p7(D10),p8(D11);
Serial esp(D8, D2); // tx, rx
Serial pc(USBTX, USBRX); // tx, rx

char IP[100];
int SERVtimeout =5;    // set server timeout in seconds incase link breaks.
int bufflen, DataRX, count, getcount, replycount, servreq, timeout;
int bufl, ipdLen, linkID, weberror, webcounter;
float Temp,Hum;
int dw,d,M,y,h,m,s;
char webcount[8];
char lasthit[30];
char timebuf[30];
char type[16];
char type1[16];
char channel[2];
char cmdbuff[32];
char replybuff[512];
char webdata[1024]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
Timer t1;
Timer t2;
Timer t3;
int PageNo=1;

void sendpage();
void ReadWebData();
void SendCMD(),getreply(),startserver(),SendWEB(),sendcheck();

// Serial Interrupt read ESP data
void callback() {    
    while (esp.readable()) {webbuff[count] = esp.getc();count++;}
    if(strlen(webbuff)>bufflen){DataRX=1;}  
}





int main()
{
    lcd.setMode(TextLCD::DispOn); 
    lcd.setBacklight(TextLCD::LightOff);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    //rtc.setTime(21,57,50);
    //rtc.setDate(1,31,5,2015);
    pc.baud(9600);
    esp.baud(9600);   
    startserver();
    t3.start();
    while(1)
    {
        if(PageNo==1){
            if(t3.read_ms () >3000){
                rtc.readDateTime(&dw,&d,&M,&y,&h,&m,&s);
                rht.readData();
                Temp=rht.getTemperatureC();
                Hum=rht.getHumidity();
                lcd.cls();
                lcd.setAddress(0,0);
                lcd.printf("%02d/%02d/%4d",d,M,y);
                lcd.setAddress(0,1);
                lcd.printf("%02d:%02d:%02d",h,m,s);
                t3.reset();
                PageNo=2;
            }
        }
        if(PageNo==2){
            if(t3.read_ms () >3000){
                lcd.cls();
                lcd.setAddress(0,0);
                lcd.printf("Temp:%.1f",Temp);
                lcd.setAddress(0,1);
                lcd.printf("Hum:%.1f",Hum);
                PageNo=3;
                t3.reset();
            }
        }
        if(PageNo==3){
            if(t3.read_ms () >3000){
                lcd.cls();
                lcd.setAddress(0,0);
                lcd.printf("P1:%3s P2:%3s",(p1==1)?"On":"Off",(p2==1)?"On":"Off");
                lcd.setAddress(0,1);
                lcd.printf("P3:%3s P4:%3s",(p3==1)?"On":"Off",(p4==1)?"On":"Off");
                PageNo=4;
                t3.reset();
            }
        }
        if(PageNo==4){
            if(t3.read_ms () >3000){
                lcd.cls();
                lcd.setAddress(0,0);
                lcd.printf("P5:%3s P6:%3s",(p5==1)?"On":"Off",(p6==1)?"On":"Off");
                lcd.setAddress(0,1);
                lcd.printf("P7:%3s P8:%3s",(p7==1)?"On":"Off",(p8==1)?"On":"Off");
                PageNo=5;
                t3.reset();
            
            }
        }
        if(PageNo==5)
        {
            if(t3.read_ms () >3000){
                lcd.cls();
                lcd.setAddress(0,0);
                strcpy(cmdbuff, "AT+CIFSR\r\n");
                timeout=1000;getcount=50;
                while(weberror==0){
                    SendCMD();getreply();
                    if (strstr(replybuff, "0.0.0.0") == NULL) {weberror=1;}  // wait for valid IP
                }
                replybuff[strlen(replybuff)] = '\0';                
                strcpy(IP, replybuff + 5);
                lcd.printf("%s",IP);
                lcd.setAddress(0,1);
                lcd.printf("Fookies-One(m8)");
                PageNo=1;
                t3.reset();
            }
        }
        
        if(DataRX==1){
            ReadWebData();
            lcd.printf("111111");
            sendpage();
            lcd.printf("22222");
            esp.attach(&callback);     
            pc.printf(" IPD Data:\r\n\n Link ID = %d,\r\n IPD Header Length = %d \r\n IPD Type = %s\r\n", linkID, ipdLen, type);        
            pc.printf("\n\n  HTTP Packet: \n\n%s\n", webdata); 
            pc.printf("  Web Characters sent : %d\n\n", bufl);
            pc.printf("  -------------------------------------\n\n");
            strcpy(lasthit, timebuf);
            servreq=0;               
        } 
    }


    return 0;

}
void startserver()
{
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");  
    strcpy(cmdbuff,"AT+RST\r\n");
    timeout=2000;getcount=600;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("%d",count);
    if (strstr(replybuff, "OK") != NULL) {
        strcpy(cmdbuff, "AT+CWMODE=1\r\n");  // set wifi to station 
        timeout=500;getcount=10;
        SendCMD();
        getreply();
        strcpy(cmdbuff, "AT+CWJAP=""Fookies-One(m8)"",""12312344""\r\n");  // set wifi to station 
        timeout=500;getcount=50;
        SendCMD();
        getreply();
        lcd.printf("\n++++++++++ Starting Server ++++++++++\r\n");
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n");  // set multiple connections. 
        timeout=500;getcount=10;
        SendCMD();
        getreply();
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", 80);
        timeout=500;getcount=10;
        SendCMD();
        getreply();
        //sprintf(cmdbuff,"AT+CIPSTO=%d\r\n",SERVtimeout);
        //timeout=500;getcount=50;
        //SendCMD();
        //getreply();
        lcd.printf("\n Getting Server IP \r\n"); 
        strcpy(cmdbuff, "AT+CIFSR\r\n");
        timeout=1000;getcount=50;
        while(weberror==0){
            SendCMD();getreply();
            if (strstr(replybuff, "0.0.0.0") == NULL) {weberror=1;}  // wait for valid IP
            }
        lcd.printf("\n Enter WEB address in your browser \r\n\n");
        replybuff[strlen(replybuff) - 8] = '\0';                
        strcpy(IP, replybuff + 5);
        sprintf(webdata,"   http://%s:%d", IP, 80);
        lcd.printf(webdata);       
        wait(2);
        bufflen=200;count=0;
        lcd.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
        esp.attach(&callback);
        }
        else{
            lcd.printf("\n++++++++++ ESP8266 error, check power/connections ++++++++++\r\n");
            while(1){}
            }
        t2.reset();t2.start();    
}    

void sendpage()
{
    char t1[1000];
        
// WEB page data     
    strcpy(webbuff, "<!DOCTYPE html>");
    strcat(webbuff, "<html><head><title>Home Status</title></head>");
    strcat(webbuff, "<body>");    
    strcat(webbuff, "<p>");   
    sprintf(t1,"%02d/%02d/%4d %02d:%02d:%02d",d,M,y,h,m,s);
    strcat(webbuff,t1);
    strcat(webbuff, "<p>");    
    strcat(webbuff,"<p>Temperature : ");
    sprintf(t1,"%.1f",Temp);
    strcat(webbuff,t1);
    strcat(webbuff, " C<p>");    
    strcat(webbuff,"<p>Humidity : ");
    sprintf(t1,"%.1f",Hum);
    strcat(webbuff,t1);
    strcat(webbuff, " %<p>");
    strcat(webbuff, "<table>");
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 1 :</td><td>");
    if(p1==1)
    {
        strcat(webbuff, "<a href=/?Light1=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light1=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 2 :</td><td>");
    if(p2==1)
    {
        strcat(webbuff, "<a href=/?Light2=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light2=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 3 :</td><td>");
    if(p3==1)
    {
        strcat(webbuff, "<a href=/?Light3=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light3=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 4 :</td><td>");
    if(p4==1)
    {
        strcat(webbuff, "<a href=/?Light4=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light4=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 5 :</td><td>");
    if(p5==1)
    {
        strcat(webbuff, "<a href=/?Light5=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light5=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 6 :</td><td>");
    if(p6==1)
    {
        strcat(webbuff, "<a href=/?Light6=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light6=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 7 :</td><td>");
    if(p7==1)
    {
        strcat(webbuff, "<a href=/?Light7=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light7=ON>OFF</a></td></tr>");
    }
    strcat(webbuff, "<tr>");
    strcat(webbuff, "<td>Light 8 :</td><td>");
    if(p8==1)
    {
        strcat(webbuff, "<a href=/?Light8=OFF>ON</a></td></tr>");
    }else{
        strcat(webbuff, "<a href=/?Light8=ON>OFF</a></td></tr>");
    }
    
    
    
    
    strcat(webbuff, "</table></p></body></html>");  
// end of WEB page data       
    bufl = strlen(webbuff); // get total page buffer length            
    sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.
    timeout=200;getcount=7;
    SendCMD();
    getreply();                                                               
    SendWEB();  // send web page
    memset(webbuff, '\0', sizeof(webbuff));
    sendcheck();              
}
void ReadWebData()
 {
    wait_ms(200);        
    esp.attach(NULL);
    count=0;DataRX=0;weberror=0;
    memset(webdata, '\0', sizeof(webdata));    
    int x = strcspn (webbuff,"+");
    if(x){
        strcpy(webdata, webbuff + x);weberror=0;                                   
        int numMatched = sscanf(webdata,"+IPD,%d,%d:%s", &linkID, &ipdLen, type); 
        
        if( strstr(webdata, "Light1=OFF") != NULL ) {p1=0;}
        if( strstr(webdata, "Light1=ON") != NULL ) {p1=1;}
        if( strstr(webdata, "Light2=OFF") != NULL ) {p2=0;}
        if( strstr(webdata, "Light2=ON") != NULL ) {p2=1;}
        if( strstr(webdata, "Light3=OFF") != NULL ) {p3=0;}
        if( strstr(webdata, "Light3=ON") != NULL ) {p3=1;}
        if( strstr(webdata, "Light4=OFF") != NULL ) {p4=0;}
        if( strstr(webdata, "Light4=ON") != NULL ) {p4=1;}
        if( strstr(webdata, "Light5=OFF") != NULL ) {p5=0;}
        if( strstr(webdata, "Light5=ON") != NULL ) {p5=1;}
        if( strstr(webdata, "Light6=OFF") != NULL ) {p6=0;}
        if( strstr(webdata, "Light6=ON") != NULL ) {p6=1;}   
        if( strstr(webdata, "Light7=OFF") != NULL ) {p7=0;}
        if( strstr(webdata, "Light7=ON") != NULL ) {p7=1;}
        if( strstr(webdata, "Light8=OFF") != NULL ) {p8=0;}
        if( strstr(webdata, "Light8=ON") != NULL ) {p8=1;}
        
        sprintf(channel, "%d",linkID);        
        if (strstr(webdata, "GET") != NULL) {servreq=1;}
        if (strstr(webdata, "POST") != NULL) {servreq=1;}
        webcounter++;
        sprintf(webcount, "%d",webcounter);
        }
            else {
                memset(webbuff, '\0', sizeof(webbuff));
                esp.attach(&callback);weberror=1;
                }  
}
// ESP Command data send
void SendCMD()
{
    esp.printf("%s", cmdbuff);      
}  
// Get Cammand and ESP status replies
void getreply()
{    
    memset(replybuff, '\0', sizeof(replybuff));
    t1.reset(); t1.start();replycount=0;
    while(t1.read_ms()< timeout && replycount < getcount) {
        if(esp.readable()) {
            replybuff[replycount] = esp.getc();replycount++;
            }
        }
    t1.stop();      
}
// Large WEB buffer data send
void SendWEB()
{    
    int i=0;
    if(esp.writeable()) {
        while(webbuff[i]!='\0') {esp.putc(webbuff[i]);i++;}
        }     
} 
//  wait for ESP "SEND OK" reply, then close IP to load web page
void sendcheck()
{
     weberror=1;timeout=500;getcount=24;
    t2.reset();t2.start();
    while(weberror==1 && t2.read() <5){        
        getreply();
        if (strstr(replybuff, "SEND OK") != NULL) {weberror=0;}  // wait for valid SEND OK 
        }
    if(weberror==1){ // restart connection
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n"); 
        timeout=500;getcount=10;
        SendCMD();getreply(); 
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", 80);
        timeout=500;getcount=10;
        SendCMD();getreply();
        }
        else{
            sprintf(cmdbuff, "AT+CIPCLOSE=%s\r\n",channel); // close current connection
            SendCMD();}       
    t2.reset();      
} 