#include "mbed.h"
#include "TextLCD.h"
#include "DS3231.h"
#include "RHT03.h"
I2C i2c(D14,D15);
TextLCD_I2C lcd(&i2c,0x4E,TextLCD::LCD16x2);
DS3231 rtc(D14,D15);
RHT03 rht(D13);
DigitalOut p1(D3),p2(D4),p3(D5),p4(D6),p5(D7),p6(D9),p7(D10),p8(D11);

int main()
{
    lcd.setMode(TextLCD::DispOn); 
    lcd.setBacklight(TextLCD::LightOff);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    //rtc.setTime(20,58,00);
    //rtc.setDate(5,22,5,2015);
    float Temp,Hum;
    int dw,d,M,y,h,m,s;
    while(1)
    {
        rtc.readDateTime(&dw,&d,&M,&y,&h,&m,&s);
        rht.readData();
        Temp=rht.getTemperatureC();
        Hum=rht.getHumidity();
        lcd.cls();
        lcd.setAddress(0,0);
        lcd.printf("%02d/%02d/%4d",d,M,y);
        lcd.setAddress(0,1);
        lcd.printf("%02d:%02d:%02d",h,m,s);
        
        wait(3);
        lcd.cls();
        lcd.setAddress(0,0);
        lcd.printf("Temp:%.1f",Temp);
        lcd.setAddress(0,1);
        lcd.printf("Hum:%.1f",Hum);
        wait(3);
        
        lcd.cls();
        lcd.setAddress(0,0);
        lcd.printf("Port1:%3s Port2:%3s",(p1==1)?"On":"Off",(p2==1)?"On":"Off");
        lcd.setAddress(0,1);
        lcd.printf("Port3:%3s Port4:%3s",(p3==1)?"On":"Off",(p4==1)?"On":"Off");
        wait(3);
        
        lcd.cls();
        lcd.setAddress(0,0);
        lcd.printf("Port5:%3s Port6:%3s",(p5==1)?"On":"Off",(p6==1)?"On":"Off");
        lcd.setAddress(0,1);
        lcd.printf("Port7:%3s Port8:%3s",(p7==1)?"On":"Off",(p8==1)?"On":"Off");
        wait(3);
    }


    return 0;

}
