#include "States.h"

Startup::Startup(uLCD_4DGL &uLCD, PinDetect &upButton, PinDetect &downButton, PinDetect &leftButton, PinDetect &rightButton)
{
    uLCD.cls();
    
    //color array for the bird on the Mexican flag. Array generated using an external program written in Java
    //(since C++ doesn't have built in libraries for easily reading images that I know of)
    int image[] = {-1, -1, -1, -1, -1, -1, -1, -1, -1, -3101112, -6512280, -9341134, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6512280, -1, -7762349, -7038369, -4407394, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -527127, -6578073, -9341134, -7630766, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2368312, -2705590, -1, -5131122, -1, -1, -1, -1, -1, -11720171, -12704232, -11844801, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6709403, -7433129, -1, -1, -1, -131589, -1, -1, -1, -1, -1, -10997993, -11720171, -7387616, -9615565, -1, -1, -1, -1, -1, -1, -1, -6512280, -9341134, -1, -3092529, -957317, -1497033, -11720171, -2565928, -11982570, -14343648, -5460820, -7387616, -11720171, -6530769, -11720171, -6135757, -1, -1, -1, -1, -1, -1721791, -1, -1, -1, -15956855, -15956855, -1, -11720171, -1, -1, -657931, -12244970, -7387616, -11720171, -7321567, -12507368, -7387616, -2972313, -1, -1, -1, -6512280, -9275340, -1, -1, -1, -12497842, -14127767, -4605511, -11720171, -7842271, -1, -6974059, -1, -6333403, -12769767, -3103898, -11456224, -11851242, -7387616, -2972313, -1, -1, -6775454, -6512280, -10049336, -1, -65794, -7685188, -14671328, -1, -9357029, -8437987, -11720171, -1, -1, -4554175, -6069707, -3762853, -11457514, -14277855, -5995691, -6267085, -9027033, -1, -6709403, -9341134, -10902329, -13581604, -1, -15956855, -7684674, -2969262, -723724, -11654634, -12572904, -13360101, -657931, -7387359, -10800096, -6069707, -12900838, -14671840, -14671840, -13360101, -4092844, -1, -8683456, -1, -5353428, -415151, -5022658, -14259346, -8013639, -473028, -12502989, -7650273, -11720171, -14671840, -3829159, -13883870, -7387616, -13884385, -7387616, -7387616, -7387616, -7387616, -7387616, -1, -6512280, -1, -415151, -1271222, -14323345, -7553345, -6783441, -3163517, -14671840, -8437729, -14671840, -2972313, -7452895, -11720171, -11194089, -14540255, -9091298, -5542615, -5542615, -9683173, -2972313, -16684984, -1, -1, -415151, -415151, -7242934, -10119532, -7553345, -1, -1, -10855846, -14671840, -10144487, -11720171, -10275040, -14606048, -7845593, -13359844, -7387616, -10733534, -7119061, -7387616, -1, -7236004, -1, -415151, -415151, -1468855, -15956855, -15956855, -14475488, -1, -7058143, -6069456, -11720171, -11720171, -2972313, -5938121, -7387616, -3629983, -2380436, -5542615, -1, -2972313, -1, -2697022, -1, -2851521, -415151, -415151, -16023163, -15956855, -11432050, -1, -6926300, -197638, -7781601, -7387616, -2972313, -7057883, -2380436, -2378882, -8699108, -11391465, -6596301, -1, -1, -6512280, -6183561, -14315334, -13581604, -1248008, -1, -15628661, -1052946, -1, -2834776, -9413339, -210371, -1, -9154260, -5542615, -1, -1, -407494, -13028309, -1, -1, -1, -1315616, -7104413, -202059, -1, -13581604, -16223577, -15956855, -685156, -535033, -1, -473028, -4280704, -723986, -1, -1, -8883410, -210371, -341179, -2380436, -1, -1, -1, -591886, -8617663, -1, -1, -13581604, -1, -15956855, -10058362, -1, -8817874, -473028, -6127546, -197638, -1, -5723023, -1, -199720, -2644400, -1, -1, -1, -1, -1, -604610, -1384775, -1, -1, -998080, -3418154, -14192789, -9928577, -6646174, -8883410, -1, -4867962, -5723023, -66052, -1, -5263998, -1, -2828616, -1, -1, -1, -1, -1120824, -8157112, -9341134, -1, -269412, -1, -15697799, -15956855, -13480372, -1, -131588, -5921678, -5723023, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6512280, -6512280, -1, -1, -1, -1, -15956855, -683358, -543558, -1, -1, -1, -473028, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7564715, -2307436, -1, -1, -1, -1, -1361079, -210370, -1, -1, -131588, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -210370, -8025524, -9078218, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7038626, -5393789, -723474, -6512280, -9341134, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2771881, -460299, -9209548, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    
    //title
    uLCD.locate(3,0);
    uLCD.text_italic(ON);
    uLCD.text_string("Mexican Standoff", 1, 1, FONT_12X16, WHITE);
    uLCD.filled_rectangle(14, 20, 47, 77, 0xCE1126);
    uLCD.filled_rectangle(47, 20, 80, 77, 0xFFFFFF);
    uLCD.filled_rectangle(80, 20, 113, 77, 0x006847);
    uLCD.BLIT(14 + 37, 20 + 17, 25, 22, image);
    uLCD.text_italic(OFF);
    uLCD.text_string("One Player",  4, 10, FONT_12X16, WHITE);
    uLCD.text_string("Two Player",   4, 12, FONT_12X16, WHITE);
    uLCD.text_string("How To Play",  4, 14, FONT_12X16, WHITE);
}

/*
 * Blocking method that handles all of the main menu navigation. Returns when a user selects an option.
 * Returns the # of the option selected.
 */
int Startup::select(uLCD_4DGL &uLCD, PinDetect &Button0, PinDetect &Button1, PinDetect &Button2, PinDetect &Button3, Music &music)
{
    DigitalOut led2(LED2);
    
    option = 0;
    uLCD.filled_circle(15,  83, 5, WHITE);
    
    do
    {
        if(!Button2)
            option += 1;
        
        if(!Button3)
            option -= 1;
            
        option = (option + 3) % 3; //wrap around... add 3 first to avoid negative modulus
        
        
        //the wait(0.2) makes the buttons polled once every .2 seconds. This makes us not have to worry about
        //debouncing, or a single button press firing multiple times, etc.
        if(option == 0)
        {
            uLCD.filled_circle(15,  83, 5, WHITE);
            uLCD.filled_circle(15,  99, 5, BLACK);
            uLCD.filled_circle(15, 115, 5, BLACK);
            wait(0.2);
        }
        else if(option == 1)
        {
            uLCD.filled_circle(15,  83, 5, BLACK);
            uLCD.filled_circle(15,  99, 5, WHITE);
            uLCD.filled_circle(15, 115, 5, BLACK);
            wait(0.2);
        }
        else if(option == 2)
        {
            uLCD.filled_circle(15,  83, 5, BLACK);
            uLCD.filled_circle(15,  99, 5, BLACK);
            uLCD.filled_circle(15, 115, 5, WHITE);
            wait(0.2);
        }
    } while(Button0 && Button1);
    
    return option;
}