#include "music.h"

//NOTE:
//starting a thread inside of a class is apparently really hard to do in RTOS
//since the function you pass to the thread should be static...
//As a workaround I simply create a static thread_helper method
//that launches the thread on behalf of the calling class.
//
//More info here: https://developer.mbed.org/forum/mbed/topic/4388/


Music::Music(wave_player &speaker_arg)
{
    speaker = &speaker_arg;
}

void Music::playMainMusic()
{
    main_music_thread = new Thread(thread_helper, this);
}

void Music::stopMainMusic()
{
    main_music_thread->terminate();
}

void Music::main_music()
{   
    while(true)
    { 
        FILE *main_music_file = fopen("/sd/titlemusic.wav", "r");
        
        if(main_music_file == NULL)
        {
            while(true)
            {
                //display error somehow. I'm having trouble definring LED
                //digital out's here, but that'd be the easiest way to display it
            }
        }
        speaker->play(main_music_file);
        fclose(main_music_file);
    }
}

void Music::thread_helper(const void *arg)
{    
    //Cast the argument to a Music instance pointer
    Music* instancePtr = (Music*)arg;
 
    //Call the thread method for the Music instance
    instancePtr->main_music();
}