#include "States.h"
#include <algorithm>


/**
 * Displays the rules of the game to the player. The right buttons are used to scroll between instruction pages.
 * Either of the left buttons will return back to the Startup screen.
 */
Rules::Rules(uLCD_4DGL &uLCD, PinDetect &button0, PinDetect &button1, PinDetect &button2, PinDetect &button3)
{
    uLCD.color(LGREY);
    uLCD.set_font_size(5, 9);
    
    int page = 0;
    bool updateText = true;
    
    
    do
    {
        if(updateText)
        {
            updateText = false;
            
            switch(page)
            {
                case 0:
                {
                    uLCD.cls();
                    uLCD.printf(" Mexican Standoff \n");
                    uLCD.printf("  First player to \n");
                    uLCD.printf(" fire the correct \n");
                    uLCD.printf("     gun wins!    \n");
                    uLCD.printf("\n");
                    uLCD.printf(" Learn the visual \n");
                    uLCD.printf("       cues!      \n");
                    uLCD.printf("\n");
                    uLCD.printf("\n");
                    uLCD.printf("    (Page 1/2)    ");
                } break;
                
                case 1:
                {
                    uLCD.cls();
                    uLCD.printf("      Video:      \n");
                    uLCD.printf("  Shoot on green. \n");
                    uLCD.printf(" Hold fire on red.\n");
                    uLCD.printf(" Arrow tells which\n");
                    uLCD.printf("gun to use. Circle\n");
                    uLCD.printf(" means use either!\n");
                    uLCD.printf("\n");
                    uLCD.printf("\n");
                    uLCD.printf("\n");
                    uLCD.printf("    (Page 2/2)    ");
                } break;
            }
        }
        
        //check to see if user has pressed button to scroll to next page
        if(!button3)
        {
            if(page != 0)
                updateText = true;
                
            page = max(0, page - 1);
        }    
        if(!button2)
        {
            if(page != 2)
                updateText = true;
                
            page = min(1, page + 1);
        }
            
    } while(button0 && button1); //evaluate this after rendering text so it doesn't immediately exit menu if button is down
}