#include "States.h"
#include "mbed.h"

//button setup using PinDetect
//  button is pushed -> false
//  button is not pushed -> true
PinDetect P1_LeftButton(p15, PullUp);
PinDetect P1_RightButton(p16, PullUp);
PinDetect P2_LeftButton(p26, PullUp);
PinDetect P2_RightButton(p29, PullUp);

//LCD setup
uLCD_4DGL uLCD(p28, p27, p21); // serial tx, serial rx, reset pin;

//speaker setup
AnalogOut speaker(p18);
wave_player waver(&speaker);

//states enum
enum StateType{MainMenu, HowTo, SinglePlayerGame, TwoPlayerGame, EndScreen};
StateType state = MainMenu;


SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

//member variables
int option;
int points;

DigitalOut led1(LED1);

main()
{        
    Music music(waver);
    
    //LCD setup
    uLCD.display_control(PORTRAIT_R);
    uLCD.baudrate(BAUD_3000000);        //jack up baud rate to max for fast display   
    uLCD.background_color(BLACK);
    uLCD.cls();
    
    music.playMainMusic();
    
    while(true)
    {
        switch(state)
        {
            case(MainMenu):
            {   
                // Set-Up Main Menu
                Startup startup(uLCD, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton);
                //startup.scores(uLCD, sd);
                option = startup.select(uLCD, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton, music);
                if(option == 0)
                    state =  SinglePlayerGame;
                if(option == 1)
                    state =  TwoPlayerGame;
                if(option == 2)
                    state = HowTo;
                break;
            }
            case(HowTo):
            {
                Rules rules(uLCD, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton);
                state = MainMenu;
                break;
            }
            case(SinglePlayerGame):
            {
                //after gameplay returns, we can use gameplay.getWinningPlayer() to find out who won.
                //this gets passed to the GameOver to display the correct winner on the screen
                Gameplay gameplay(uLCD, 1, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton);
                GameOver gameover(uLCD, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton, gameplay.getWinningPlayer());
                state = MainMenu;
                break;
            }
            case(TwoPlayerGame):
            {
                Gameplay gameplay(uLCD, 2, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton);
                GameOver gameover(uLCD, P1_LeftButton, P1_RightButton, P2_LeftButton, P2_RightButton, gameplay.getWinningPlayer());
                state = MainMenu;
                break;
            }
        }//end switch
    }//end while    
}//end main