#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include <stdlib.h>
#include <time.h>
#include "music.h"
#include "SDFileSystem.h"

//this file includes the header data for all of the classes that represent the states that the game can
//be in: namely the main menu (Startup), the Rules page, Gameplay, and Game Over

class Startup
{
    public:
        //CONSTRUCTOR
        Startup(uLCD_4DGL &uLCD, PinDetect &upButton, PinDetect &downButton, PinDetect &leftButton, PinDetect &rightButton);
        
        int select(uLCD_4DGL &uLCD, PinDetect &upButton, PinDetect &downButton, PinDetect &leftButton, PinDetect &rightButton,
                    Music &music);
    
    private:
        int option;
};

class Rules
{
    public:
        Rules(uLCD_4DGL &uLCD, PinDetect &upButton, PinDetect &downButton, PinDetect &leftButton, PinDetect &rightButton);
};

enum Prompt{HoldFire, Either, Down, Up};

//
class Gameplay
{
    public:
        // CONSTRUCTOR 
        Gameplay(uLCD_4DGL &uLCD, int numberOfPlayers, 
                  PinDetect &Button0, PinDetect &Button1, 
                  PinDetect &Button2, PinDetect &Button3);
       
        // GET FUNCTIONS
        int getPoints(int player);
        int getWinningPlayer();
        
        // SET FUNCTIONS
        void setPoints(int player, int points, uLCD_4DGL &uLCD);
    
    private:
        int *points;
        int numPlayers;
        int winningPlayer;
        
        void drawGun(uLCD_4DGL &uLCD, int x, int y, bool facingRight);
        void displayUpArrow(uLCD_4DGL &uLCD);
        void displayDownArrow(uLCD_4DGL &uLCD);
        void displayCircle(uLCD_4DGL &uLCD);
        void displayXs(uLCD_4DGL &uLCD);
        void clearPrompt(uLCD_4DGL &uLCD);
        
        void countdown(uLCD_4DGL &uLCD);
        void clearCountdown(uLCD_4DGL &uLCD);
        
        void renderScore(uLCD_4DGL &uLCD);
        void resetPoints(uLCD_4DGL &uLCD);
};

class GameOver
{
        public: 
            GameOver(uLCD_4DGL &uLCD, PinDetect &Button0, PinDetect &Button1, 
                                        PinDetect &Button2, PinDetect &Button3, 
                                        int winningPlayer);
};

class CPU
{
    private:
        int difficulty;
    public:
        CPU();
        CPU(int difficulty);
    
        float shootTime();
        bool shootAnswer(Prompt correctAnswer);
};