/*2021/06/27
DFplayerを動作させるサンプルプログラム
仕様：nucleo f401REを使用し、青いボタンを押したら、次の曲が流れる。
　曲が停止している間は、mbedについているLEDを点灯し、曲が流れている間はLEDが点滅する。

使用ポート：
 青ボタン：PC_13
 UART RX：PA_10
 UART TX：PA9
 LED点灯、点滅：LED1
*/

#include "mbed.h"
#include "DFPlayerMini.h"

DigitalOut myled(LED1); //LED
DigitalIn sw(PC_13);  //再生ボタン

DFPlayerMini mp3(PA_9,PA_10); //TX：PA_9(D8) RX：PA_10(D2)
DigitalIn busy(PB_3);   //DFPlayerMiniのBUSYと接続する

int main() {
    while(1)
    {
            if(sw == 0){ //青ボタンを押すと次の曲を再生
                mp3.mp3_next(); //0001.mp3を再生
                wait(0.1);
            }
            if (busy == 1 ){        //再生停止している場合は、LED点灯
                myled = 1;   
            }else if( busy == 0 )   //再生中は、lEDを点滅させる
            {
                wait(0.1);
                //LEDを点滅させる
                myled = !myled;
                wait(0.2);
            }
    }
}
