// for LPC1768
//binary counter with 4 onboard leds. counts +1 with every button press

#include "mbed.h"
#define PRESSED 0
#define UNPRESSED 1
#define BUTTONPIN p8

int getNext(); //get next num for counter. ( counts 0 to 15) after 15 there is a rollback. 
void setLeds(int);  //sets the leds to show in binary the argument
Serial pc(USBTX, USBRX);//initialize serial connection

DigitalIn button(BUTTONPIN); //button on pin8
DigitalOut leds[4]={ DigitalOut(LED1), DigitalOut(LED2), DigitalOut(LED3), DigitalOut(LED4) };
 
//----------------------------------------------- 
int main() {
    
    button.mode(PullUp); //set button internal pullup
    
    bool previousState=button;
    bool currentState;
   
    while(1) {//polling
        
        currentState=button;
        if(currentState==PRESSED && previousState==UNPRESSED){ //on button push
              setLeds(getNext());

            
        }
        previousState=currentState;
        wait(0.1); //small delay for debounce
  
    }
}
//------------------------------------------
void setLeds(int num){
        
              int eights    =num/8;     //how many of 8's the number has...
              int fours     =(num - eights*8) /4 ;
              int twos      =(num - eights*8 -fours*4)/2;
              int ones      =num%2; 
              
              leds[0]=eights;
              leds[1]=fours;
              leds[2]=twos;
              leds[3]=ones;
              pc.printf("dec=%d bin=%d%d%d%d \n",num,eights,fours,twos,ones); 
    
}
//-----------------------------------------------
int getNext(){
    static int i=0;
    if(i==15)i=0;
    else i++;
    
    return i;
    
    }