//    touch2RGB
//program for FRDM-KL25Z
//each touch on the touch sensor switches embedded led between Red Green and Blue colours

#include "mbed.h"
#include "TSISensor.h"

const float TOUCH_THRESHOLD=0.5;   //sensor returns analog value from 0.0(no touch) to 1.0(full touch) to determine when there is a touch
enum  colour { RED=0,GREEN,BLUE};

bool analog2dig(float );
void setColour(colour);

DigitalOut r (LED_RED);
DigitalOut g (LED_GREEN);
DigitalOut b (LED_BLUE);
colour currentColour=RED;

Serial pc(USBTX,USBRX); //serial connection with pc
TSISensor tsi; //touchSensor



int main() {
     bool previousState=analog2dig(tsi.readPercentage());
     bool currentState;
     
     setColour(currentColour); //set initial colour
     pc.printf("begin - initial state=%d\n",previousState);
     
     while(1){
        currentState=analog2dig(tsi.readPercentage());
        //pc.printf("state=%d\n",currentState);  
        if(previousState==false && currentState==true){  //touch detected
            switch (currentColour){
                case RED:
                    setColour(GREEN);
                    break;
                case GREEN:
                    setColour(BLUE);
                    break;
                case BLUE:
                    setColour(RED);
                    break;
                };//end switch
        }//end if
        previousState=currentState;
        wait(0.1);
 }
}

//---------------------------------------------
void setColour(colour col){
    switch(col){
        case RED:
            r=0;  // 0 enables the led
            g=1;  // 1 disables the led
            b=1;
            currentColour=RED;        
            break;
        case GREEN:
            r=1;
            g=0;
            b=1;
            currentColour=GREEN;
            break;
        case BLUE:
            r=1;
            g=1;
            b=0;
            currentColour=BLUE;
            break;
    }
    return;
} 


//-----------------------------------------------
bool analog2dig(float analogRead){
    return (analogRead>=TOUCH_THRESHOLD)?true:false;

    }