/**
* @author Damien Frost
*
* @section LICENSE
*
*   Copyright (c) 2016 Damien Frost
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
* @file "Commands.h"
*
* @section DESCRIPTION
*   Commands used in the IoT example
*
*/

#ifndef IQ_COMMANDS_H
#define IQ_COMMANDS_H

#include "StatusReg.h"
#include "globals.h"

#define BIT0    0x1 
#define BIT1    0x2 
#define BIT2    0x4 
#define BIT3    0x8 
#define BIT4    0x10 
#define BIT5    0x20 
#define BIT6    0x40 
#define BIT7    0x80 
#define BIT8    0x100 
#define BIT9    0x200 
#define BIT10   0x400 
#define BIT11   0x800 
#define BIT12   0x1000 
#define BIT13   0x2000 
#define BIT14   0x4000 
#define BIT15   0x8000 

#define BIT16   0x10000 
#define BIT17   0x20000 
#define BIT18   0x40000 
#define BIT19   0x80000 
#define BIT20   0x100000 
#define BIT21   0x200000 
#define BIT22   0x400000 
#define BIT23   0x800000 
#define BIT24   0x1000000 
#define BIT25   0x2000000 
#define BIT26   0x4000000 
#define BIT27   0x8000000 
#define BIT28   0x10000000 
#define BIT29   0x20000000 
#define BIT30   0x40000000 
#define BIT31   0x80000000 

// Status regsiter flags:
#define SF_SERVERCONNECTED      BIT0
#define SF_AUTOCONNECT          BIT1        // Set this flag to automatically start connecting to the websocket server
#define SF_WIRELESSCONNECTED    BIT2        // Flag to indicate whether or not the wireless network is connected
#define SS_PWMOVERRUNFLAG       BIT3        // Flag to indicate when the PWM interrutp is still running
                                            
// Wifi Commands
#define     NO_WIFI_CMD             0
#define     CV_LED_WIFI_CMD         1
#define     CV_PWM_PERIOD_US_CMD    2


extern StatusReg IotStatus;

#endif  /* IQ_COMMANDS_H */