// ************
// * iQ_PWM.h *
// ************
//
// Created: 2015/03/19
// By: Damien Frost
//
// Description:
// This file provides all of the functions used to configure the 
// high speed PWM module of the STM32F401RE microcontroller.

#ifndef PWWM_H
#define PWWM_H

#define SETUDIS     TIM1->CR1 |= TIM_CR1_UDIS
#define CLEARUDIS   TIM1->CR1 &= ~TIM_CR1_UDIS
#define PWMHIGHPRIORITY 0
#define PWMLOWPRIORITY  1

#define PS_RESET    0
#define PS_SHIFT    1

#define PWMST_SETUPCONV         0
#define PWMST_STARTCONV         1
#define PWMST_RUNSCSKDC         2
#define PWMST_CALCNEWPH         3
#define PWMST_SETNEWPH          4
#define PWMST_SHIFT             5
#define PWMST_SAMPLECHTROUGH    6
#define PWMST_WAITSAMPLETROUGH  7    
#define PWMST_WAIT              8
#define PWMST_SAMPLECHHILL      9
#define PWMST_WAITSAMPLEHILL    10
#define PWMST_SKIPONECYCLE      11
#define PWMST_MAXST             12

#define PWMSTEP_US  (10.0f/839.0f)
#define TS          (PWMPER_US/1000000)
#define PWMARRMAX   (65535)



// Global variables:
extern float CurrentPhaseShift;
extern unsigned int OneCycleSkipExitState;
extern void (*const pwmsm_StateFunction [PWMST_MAXST]) (void);

// Function prototypes:

// Configures the PWM for use, using an initial duty cycle of 'duty'
void ConfigurePWM(float duty_us, float period_us);

// PWM ISR, used fo rdebugging purposes:
void TIM1_CC_IRQHandler(void);

// Configures the Dead time of the PWM, using an initial dead time of 'dt':
void ConfigureDeadTime(float dt_ns);

// Set duty by specifying the duty cycle in us:
float SetDuty_us(float duty_us);

// Set a new duty cycle by specifying it as a number between 0 and 1:
float SetDuty(float duty);

// This function checks to make sure the duty cycle is within the min and max constraints, it is called by the SetDuty functions.
float CheckMinMaxDuty(float duty);

// Turn on the the PWM signal:
void TurnOnPWM(bool trueForOn);

// Apply a phase shift:
int PhaseShift(unsigned int cmd, float phase);

// Set a new PWM Period:
void SetPWMPeriodAndDuty(int pwmper);
void SetPWMPeriodAndDuty_us(float period);

// Set the time at which the PWM isr fires:
void SetISRTime(unsigned int isrtime);

// PWM State Machine functions:
void pwmsm_SetupConv(void);         // PWMST_SETUPCONV          0
void pwmsm_StartConv(void);         // PWMST_STARTCONV          1
void pwmsm_RunScskdc(void);         // PWMST_RUNSCSKDC          2
void pwmsm_CalcNewPh(void);         // PWMST_CALCNEWPH          3
void pwmsm_SetNewPh(void);          // PWMST_SETNEWPH           4
void pwmsm_Shift(void);             // PWMST_SHIFT              5
void pwmsm_SampleChTrough(void);    // PWMST_SAMPLECHTROUGH     6
void pwmsm_WaitSampleTrough(void);  // PWMST_WAITSAMPLETROUGH   7
void pwmsm_Wait(void);              // PWMST_WAIT               8
void pwmsm_SampleChHill(void);      // PWMST_SAMPLECHHILL       9
void pwmsm_WaitSampleHill(void);    // PWMST_WAITSAMPLEHILL     10
void pwmsm_SkipOneCycle(void);      // PWMST_SKIPONECYCLE       11
void SetupOneCycleSkip(unsigned int nextState);

#endif  /* PWWM_H */
