#include "mbed.h"
#include "uLCD_4DGL.h"
#include "TMP36.h"
#include "rtos.h"
uLCD_4DGL uLCD(p28, p27, p30); // serial tx, serial rx, reset pin;
TMP36 myTMP36(p15);
DigitalOut Ctrl(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
PwmOut mymotor(p22);
RawSerial blue(p9,p10);
Mutex uLCD_mutex; 

double speed = 0.0;
float tempC, tempF;

void Tempature_thread(){
    while(1){
         tempC = myTMP36.read();
         //convert to degrees F
         tempF = (9.0*tempC)/5.0 + 32.0;
         uLCD_mutex.lock();
         uLCD.locate(0,0);
         uLCD.printf("The Temperature is: %3.1f F \n", tempF);
         uLCD_mutex.unlock();
         wait(1);
    }
}
int main()
{
     blue.baud(9600);
     char bnum='1';
     Ctrl = 1;
     uLCD.reset();
     Thread t0;
     t0.start(Tempature_thread);
     while(1) 
     {
         if(bnum == '1'){
             led1 = 1;
             led2 = 0;
             led3 = 0;
             uLCD_mutex.lock();
             uLCD.locate(0,10);
             uLCD.printf("Bluetooth override OFF   ");
             uLCD_mutex.unlock();
             if(tempF > 75.0){
                 mymotor.write(1);
                 uLCD_mutex.lock();
                 uLCD.locate(0,5);
                 uLCD.printf("Fan is ON   ");  
                 uLCD_mutex.unlock();        
             }
             else {
                 mymotor.write(0); 
                 uLCD_mutex.lock();
                 uLCD.locate(0,5);
                 uLCD.printf("Fan is OFF   ");
                 uLCD_mutex.unlock();
             }
          }
          else if(bnum == '2'){
                 led1 = 0;
                 led2 = 1;
                 led3 = 0;
                 mymotor.write(1);
                 uLCD_mutex.lock();
                 uLCD.locate(0,5);
                 uLCD.printf("Fan is ON   ");
                 uLCD.locate(0,10);
                 uLCD.printf("Bluetooth override ON   ");
                 uLCD_mutex.unlock();
          }
          else if(bnum == '3'){
                 led1 = 0;
                 led2 = 0;
                 led3 = 1;
                 mymotor.write(0); 
                 uLCD_mutex.lock();
                 uLCD.locate(0,5);
                 uLCD.printf("Fan is OFF   ");
                 uLCD.locate(0,10);
                 uLCD.printf("Bluetooth override ON   ");
                 uLCD_mutex.unlock();
          }
          if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                bnum = blue.getc(); //button number
            }
          }
     }
}
