/*
 * - Proyecto:      SABMiller ILC
                    Velocímetro digital
                    CONDUSE

 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       Nucleo F091RC
 * - Referencias:
 * - Fecha:         2016/Agosto
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
*/

#include "mbed.h"
#include "BufferedSerial.h"
#include "constantes.hpp"
#include "ConduSe.h"

// HARDWARE SETUP
//***********************************
extern BufferedSerial cp(PC_4, PC_5, BUFF_SIZE, TX_MULTIP);     // USART3
extern Serial usb(USBTX, USBRX);                               // USART2

extern DigitalOut display_unidades[7] = {
       PA_3, PA_2, PA_10, PB_3, PB_5, PB_4, PB_10
       }; // a, b, c, d, e, f, g

extern DigitalOut display_decenas[7] = {
       PA_8, PA_9, PC_7, PB_6, PA_7, PA_6, PA_5
       }; // a, b, c, d, e, f, g

extern DigitalOut display_centenas[2] = {
       PB_9, PB_8
       }; // b, c

extern RGBLed status_led(PB_13, PB_14, PB_15);  // LED RGB
extern PwmOut buzzer(PA_11);
extern PwmOut blink_rgb(PC_6);
extern PwmOut blink_d7s(PC_8);
extern DigitalOut myled(LED1);                 


//
//***********************************

int main()
{
    // CONFIGURAR PUERTOS
    cp.baud(9600);
    usb.baud(115200);
    usb.printf("INICIO!\r\n\r\n");

    // DECLARACIÓN DE VARIABLES
    float velocidad_gps_actual = 0.0;
    int centenas = 0;
    int decenas = 0;
    int unidades = 0;
    int bytes_entrantes[35] = {0};
    int contador_errores = 0;
    int trama_recibida = 0;     // Lógica de código
    int trama_valida = 0;       // Lógica de código
    iniciar_data_cp(bytes_entrantes);
    status_led.write(1.0, 1.0, 1.0);
    
    // Iniciar display con --
    iniciar_display7s(display_centenas, display_decenas, display_unidades);

    while(1) {
        // Enviar consulta al CP ConduSe
        consultar_conduse(&cp);

        // Recibir datos de la trama del CP
        trama_recibida = recibir_respuesta_conduse(&cp, bytes_entrantes);
        
        
        // Procesar trama recibida
        if (trama_recibida) {
            usb.printf("Trama recibida - OK\r\n");
            trama_valida = validar_trama_conduse(bytes_entrantes);

            if (trama_valida) {
                usb.printf("Trama valida - OK\r\n"); 
                extraer_velocidad_conduse(bytes_entrantes,
                                          &velocidad_gps_actual);

                if ((velocidad_gps_actual >= CONDUSE_MIN_VEL) &&
                    (velocidad_gps_actual <= CONDUSE_MAX_VEL)) {
                        
                    analizar_velocidad_conduse(&velocidad_gps_actual,
                    &centenas, &decenas, &unidades);
                    usb.printf("Velocidad: %d%d%d\r\n", centenas, decenas, unidades);
                    
                    // Enviar datos a Display
                    /* ************************************************** */
                    // Segmento para prototipo:
                    presentar_velocidad(&centenas, &decenas, &unidades, display_centenas, display_decenas, display_unidades);
                        
                    actualizar_led(&velocidad_gps_actual, &myled, &status_led);
                    /* ************************************************** */
                    contador_errores = 0;
                    
                } else {
                    usb.printf("Velocidad fuera de rango - ERROR\r\n");
                    contador_errores++;
                }
            } else {
                usb.printf("Trama valida - ERROR\r\n");
                contador_errores++;
            }
        } else {
            usb.printf("Trama recibida - ERROR\r\n");
            contador_errores++;
        }

        if (contador_errores>=5) {
            // Presentar mensaje de error
            usb.printf("Display7s -> EEE\r\n");
            mostrar_error7s(display_centenas, display_decenas, display_unidades);
            status_led.write(1.0, 1.0, 1.0);
        }

        // Limpiar variables
        usb.printf("...\r\n");
        iniciar_data_cp(bytes_entrantes);
        myled = !myled;
        wait(1); //
    }
}