/*
 * - Proyecto:      SABMiller ILC  
                    Velocímetro digital
                    CONDUSE
                    
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       Nucleo F091RC
 * - Referencias:
 * - Fecha:         2016/Agosto
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
*/

#include "constantes.hpp"

// DEFINICIÓN DE CONSTANTES PARA CONDUSE //
extern const int QUERRY_CONDUSE[9] = {0x24, 0x5A, 0x01, 0x00, 0x09, 0x00, 0x83, 0x00, 0x83};
extern const float KNOTS = 1.85;
extern const int BYTE0_CONDUSE = 0x24;
extern const int BYTE1_CONDUSE = 0x5A;
extern const int CONDUSE_VAL0 = 0;
extern const int CONDUSE_VAL1 = 1;
extern const int CONDUSE_VELOCIDAD = 19;
extern const float CONDUSE_MIN_VEL = 0.0;
extern const float CONDUSE_MAX_VEL = 140.0;
extern const float VEL_RALENTI = 1.0;
extern const float VEL_ADVERTENCIA = 64.0;
extern const float VEL_LIMITE = 70.0;

// DEFINICIÓN PARA DISPLAY DE 7 SEGMENTOS
extern const int DIGITOS[10] [7] = { // a, b, c, d, e, f, g
                                    {1, 1, 1, 1, 1, 1, 0},  // CERO
                                    {0, 1, 1, 0, 0, 0, 0},  // UNO
                                    {1, 1, 0, 1, 1, 0, 1},  // DOS
                                    {1, 1, 1, 1, 0, 0, 1},  // TRES
                                    {0, 1, 1, 0, 0, 1, 1},  // CUATRO
                                    {1, 0, 1, 1, 0, 1, 1},  // CINCO
                                    {1, 0, 1, 1, 1, 1, 1},  // SEIS
                                    {1, 1, 1, 0, 0, 0, 0},  // SIETE
                                    {1, 1, 1, 1, 1, 1, 1},  // OCHO
                                    {1, 1, 1, 1, 0, 1, 1}  // NUEVE
                                   };
extern const int CIEN_MAYOR[2] = {1,1};
extern const int CIEN_MENOR[2] = {0,0};
extern const int GUION[7] = {0,0,0,0,0,0,1};
extern const int ERROR_D7S[7] = {1,0,0,1,1,1,1};

// CONSTANTES PARA COLORES
extern const float COLORES[5] [3] = { // R, G, B ANODO COMÚN
                                        {1.0000,0.3647,0.0902}, // CELESTE
                                        {1.0000,0.2157,0.7490}, // VERDE
                                        {0.0000,0.0510,1.0000}, // AMARILLO
                                        {0.0000,0.5020,0.8471}, // NARANJA
                                        {0.0706,0.8902,0.8588} // ROJO
                                    };
                                    
/* CATODO COMÚN:
{ // R, G, B
    {0.0000, 0.6353, 0.9098}, // CELESTE
    {0.0000, 0.7843, 0.2510}, // VERDE
    {1.0000, 0.9490, 0.0000}, // AMARILLO
    {1.0000, 0.4980, 0.1529}, // NARANJA
    {0.9294, 0.1098, 0.1412}  // ROJO
};                                    
*/
// OTRAS CONSTANTES
extern const int BUFF_SIZE = 128;
extern const int TX_MULTIP = 1;
const int T_ESPERA_CP = 300; // mili segundos
const int T_TX = 100; // mili segundos
