/**
 * @file testing.cpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */

#include "mbed.h"
#include "constantes.hpp"

extern Serial pcusb;
extern BusOut display_H;
extern BusOut display_dM;
extern BusOut display_uM;
extern BusOut torreLuz;
extern DigitalOut   display_DP;



void test_display7s() {
int x = 0;
    pcusb.printf("\r\n*** PRUEBA DE DIGITOS ***");

    // Apagar todo
    torreLuz.write(COLOR_TORRE_LUZ[APAGADO_TL]);
    display_uM.write(DIGITOS[APAGADO_7S]);
    display_dM.write(DIGITOS[APAGADO_7S]);
    display_H.write(DIGITOS[APAGADO_7S]);
    display_DP = 0;
    wait_us(750000);


    // Unidades de minutos
    display_DP = 1;
    pcusb.printf("\r\n\r\nUnidades de minuto:");
    torreLuz.write(COLOR_TORRE_LUZ[VERDE]);
    for (x=0; x<11; x++) {
        display_uM.write(DIGITOS[x]);
        pcusb.printf("\r\n%d = %02X", x, DIGITOS[x]);
        wait_us(750000);
    }

    // Decenas de minutos
    pcusb.printf("\r\n\r\nDecenas de minuto:");
    torreLuz.write(COLOR_TORRE_LUZ[AMARILLO]);
    for (x=0; x<11; x++) {
        display_dM.write(DIGITOS[x]);
        pcusb.printf("\r\n%d = %02X", x, DIGITOS[x]);
        wait_us(750000);
    }

    // Horas
    pcusb.printf("\r\n\r\nUnidades de hora:");
    torreLuz.write(COLOR_TORRE_LUZ[ROJO]);
    for (x=0; x<11; x++) {
        display_H.write(DIGITOS[x]);
        pcusb.printf("\r\n%d = %02X", x, DIGITOS[x]);
        wait_us(750000);
    }

    // Mantener todo encendido por 3 minutos
    pcusb.printf("\r\n\r\nMostrando 8:88");
    display_DP = 1;
    display_uM.write(DIGITOS[OCHO_7S]);
    display_dM.write(DIGITOS[OCHO_7S]);
    display_H.write(DIGITOS[OCHO_7S]);

    // Espera de 3 minutos
    pcusb.printf("\r\nEsperando %d segundos", (x*5));
    wait_us(3000000);

    torreLuz.write(COLOR_TORRE_LUZ[APAGADO_TL]);
    display_uM.write(DIGITOS[APAGADO_7S]);
    display_dM.write(DIGITOS[APAGADO_7S]);
    display_H.write(DIGITOS[APAGADO_7S]);
    display_DP = 0;
    pcusb.printf("\r\n*** FIN DE LA PRUEBA ***\r\n");
}