/**
 * @file myPinout.hpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */


#ifndef __MY_PINOUT_HPP
#define __MY_PINOUT_HPP

    #define BAY_NUMBER  4

    #if (BAY_NUMBER == 4)
        // Digital Outputs para Digitos de 7 segmentos
        #define A_HOUR      PB_9
        #define B_HOUR      PB_12
        #define C_HOUR      PB_8
        #define D_HOUR      PA_11
        #define E_HOUR      PC_9
        #define F_HOUR      PA_12
        #define G_HOUR      PC_8
        #define A_DECE      PB_10
        #define B_DECE      PB_1
        #define C_DECE      PA_8
        #define D_DECE      PB_2
        #define E_DECE      PA_9
        #define F_DECE      PB_11
        #define G_DECE      PC_7
        #define A_MINU      PA_10
        #define B_MINU      PB_13
        #define C_MINU      PB_3
        #define D_MINU      PB_14
        #define E_MINU      PB_5
        #define F_MINU      PB_15
        #define G_MINU      PB_4
        #define DP_HOUR     PC_6

        // Digital Outputs para Semaforo
        #define SEMAFORO_V  PB_0
        #define SEMAFORO_A  PA_4
        #define SEMAFORO_R  PA_1

        // UART
        #define GV300_TX    PC_0
        #define GV300_RX    PC_1
        #define RF_ID_TX    PB_6        // #define RF_ID_TX    PC_4
        #define RF_ID_RX    PB_7        // #define RF_ID_RX    PC_5
        #define LIDAR_TX    PC_4        // #define LIDAR_TX    PB_6
        #define LIDAR_RX    PC_5        // #define LIDAR_RX    PB_7

    #else
        // Digital Outputs para Digitos de 7 segmentos
        #define A_HOUR      PB_9
        #define B_HOUR      PB_12
        #define C_HOUR      PB_8
        #define D_HOUR      PA_11
        #define E_HOUR      PC_9
        #define F_HOUR      PA_12
        #define G_HOUR      PC_8
        #define A_DECE      PB_10
        #define B_DECE      PB_1
        #define C_DECE      PA_8
        #define D_DECE      PB_2
        #define E_DECE      PA_9
        #define F_DECE      PB_11
        #define G_DECE      PC_7
        #define A_MINU      PA_10
        #define B_MINU      PB_13
        #define C_MINU      PB_3
        #define D_MINU      PB_14
        #define E_MINU      PB_5
        #define F_MINU      PB_15
        #define G_MINU      PB_4
        #define DP_HOUR     PC_6

        // Digital Outputs para Semaforo
        #define SEMAFORO_V  PB_0
        #define SEMAFORO_A  PA_4
        #define SEMAFORO_R  PA_1

        // UART
        #define GV300_TX    PC_0
        #define GV300_RX    PC_1
        #define RF_ID_TX    PC_4
        #define RF_ID_RX    PC_5
        #define LIDAR_TX    PB_6
        #define LIDAR_RX    PB_7
    #endif
#endif // __MY_PINOUT_HPP