/**
 * @file main.cpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */

#include    "mbed.h"
#include    "stm32f0xx_hal_iwdg.h"
#include    "BufferedSerial.h"
#include    "myPinout.hpp"
#include    "f_basicas.hpp"
#include    "constantes.hpp"
#include    "testing.hpp"
#include    "tagid.hpp"
#include    "lidar_tfminiplus.hpp"
#include    "exe_lidar.hpp"
#include    "exe_rfid.hpp"

/** CONFIGURACIÓN DE INTERFACES     ***************************************** */
Serial          pcusb(USBTX, USBRX);
Serial          gv300(GV300_TX, GV300_RX);
BufferedSerial  rf_id(LIDAR_TX, LIDAR_RX));
BufferedSerial  lidar(RF_ID_TX, RF_ID_RX);
InterruptIn     mybutton(USER_BUTTON);
DigitalOut      myled(LED1);
BusOut          display_H(A_HOUR, B_HOUR, C_HOUR, D_HOUR, E_HOUR, F_HOUR, G_HOUR);
BusOut          display_dM(A_DECE, B_DECE, C_DECE, D_DECE, E_DECE, F_DECE, G_DECE);
BusOut          display_uM(A_MINU, B_MINU, C_MINU, D_MINU, E_MINU, F_MINU, G_MINU);
DigitalOut      display_DP(DP_HOUR);
BusOut          torreLuz(SEMAFORO_V, SEMAFORO_A, SEMAFORO_R);
static IWDG_HandleTypeDef       my_iwdg;    // HAL BASED


/** BANDERAS/FLUJO DE CÓDIGO        ***************************************** */
bool    queryLIDAR              = false;
bool    tx_heartbeatSKT         = false;
bool    add_a_minute            = false;
bool    do_test                 = false;

/** VARIABLES                       ***************************************** */
float   tiempo_actual           = 0.0;        // Para almacenar el valor del temporizador
bool    lidar_respuesta         = false;      // Para determinar si el LiDAR respondió al External Trigar
bool    lidar_valido            = false;      // Para determinar si la respuesta LiDAR es valida
bool    mostrar_tiempo          = false;      // Para determinar si se encienden o apagan los Display de 7s
char    lidar_rx_frame[18];                   // Para almacenar la trama de respuesta del LiDAR
char    skytrack_frame[128];                  // Para almacenar la trama a enviar a Skytrack
char    buffer_antena_ID[256];                // Para almacenar el ID del cabezal ASCII-puro desde RFiD -19
char    actual_trailerID_HEX[15];             // Para almacenar el ID recibido del cabezal en formato HEX-ASCII -15
char    antena_trailerID_HEX[15];             // Para almacenar el ID del cabezal previo en formato HEX-ASCII
int     previo_semaforo         = 0;
int     rfid_respuesta          = 0;          // Para almacenar los bytes recibidos de la antena RFiD
int     tiempo_luz_amarilla     = 0;          // Tiempo para encender la luz amarilla
int     tiempo_luz_roja         = 0;          // Tiempo para encender la luz roja
int     horas                   = 0;          // Acumulador de horas
int     dminutos                = 0;          // Acumulador de decenas de minutos
int     uminutos                = 0;          // Acumulador de unidades de minutos
int     rtc_delta               = 0;          // Para hacer la comparación con los tiempos, y calcular el tiempo total en Bahia
int     bahia_vacia             = 0;          // Contador para determinar cuando una bahía está vacía, según RFiD
int     lidar_vacio             = 0;          // Contador para determinar cuando una bahía está vacía, según LiDAR
int     lidar_contador_no_ack   = 0;          // Contador para determinar cuantas veces no ha respondido el LiDAR
int     contador_diferentes     = 0;          // Para contar la cantidad de TAGiD Diferentes
int     comparacion             = 0;          // Para comparar cadenas cuando es diferente el RFiD
int     contador_tramas         = 0;          // Contador de tramas enviadas al CP
int     distancia               = 0;          // Almacenar lectura de distancia por LiDAR
int     w                       = 0;          // Registro de trabajo de multiples usos





/** TICKER DE MBED                  ***************************************** */
Timer   t_apagado;
Timer   t_ocupado;
Ticker  ticker_funcionando;     // Ticker para hacer titilar un led
Ticker  ticker_heartbeat;       // Ticker para transmitir a Skytrack
Ticker  ticker_minuto;          // Ticker para contar un minuto
Ticker  ticker_query_LiDAR;     // Ticker para Consultar LiDAR


/** FUNCIONES GENERALES             ***************************************** */
void funcionando() {
    myled = !myled;
}

void hearbeat_SKT() {
    tx_heartbeatSKT = true;

}

void minute_passed() {
    add_a_minute = true;
}

void pressed() {
    do_test = true;
}

void do_querryLIDAR(){
    queryLIDAR = true;
}


int main()
{
    pcusb.baud(115200);                             // Configuracion de Baudrate para la interfaz serial para USB
    gv300.baud(115200);                             // Configuración de Baudrate para el cp gv300
    rf_id.baud(115200);                             // Configuración de Baudrate para el lector RFiD
    lidar.baud(115200);                             // Configuración de Baudrate para el LiDAR

    torreLuz.write(COLOR_TORRE_LUZ[APAGADO_TL]);    // Apagar Torre de Luz
    display_uM.write(DIGITOS[APAGADO_7S]);          // Apagar display de unidades de minuto
    display_dM.write(DIGITOS[APAGADO_7S]);          // Apagar display de decenas de minuto
    display_H.write(DIGITOS[APAGADO_7S]);           // Apagar display de horas

    memset(antena_trailerID_HEX, '\0', sizeof antena_trailerID_HEX);
    memset(actual_trailerID_HEX, '\0', sizeof actual_trailerID_HEX);
    memset(buffer_antena_ID, '\0', sizeof buffer_antena_ID);
    
    mybutton.fall(&pressed);
    ticker_funcionando.attach(&funcionando, 2.0);
    ticker_heartbeat.attach(&tx_skytrack, TIME_HEARTBEAT);
    ticker_query_LiDAR.attach(&do_querryLIDAR, 2.0);

    booting_gtdat(&pcusb, &gv300);                  // Enviar notificación de inicio
    lidar.write(TFMINIPLUS_UPDATE_RATE,6);
    flush_uart_rx(&lidar);

    /**
     * @brief   INICIAR WATCHDOG
     *          Se crea una instancia para el Watchdog, se define el pre-escaler
     *          y el valor máximo en caso que no se actualice se genera el reinicio.
    */
    my_iwdg.Instance        = IWDG;
    my_iwdg.Init.Prescaler  = IWDG_PRESCALER_256;
    my_iwdg.Init.Reload     = 0x0FFF;
    my_iwdg.Init.Window     = IWDG_WINDOW_DISABLE;
    HAL_IWDG_Init(&my_iwdg);
    booting_gtdat(&pcusb, &gv300);

    while (true) {
        if (do_test) {
            do_test = false;
            HAL_IWDG_Refresh(&my_iwdg);
            test_display7s();
            HAL_IWDG_Refresh(&my_iwdg);
        }

        if (add_a_minute) { 
            add_a_minute = false;
            actualizar_minuto();
        }

        if (tx_heartbeatSKT) {
            tx_heartbeatSKT = false;
            memset(skytrack_frame, '\0', sizeof(skytrack_frame));

        }

        if (queryLIDAR) {
            queryLIDAR = false;
            exe_LIDAR();
        }

        exe_RFiD();
        memset(skytrack_frame, '\0', sizeof(skytrack_frame));
        memset(antena_trailerID_HEX, '\0', sizeof(antena_trailerID_HEX));

        //! Actualizar Watchdog
        HAL_IWDG_Refresh(&my_iwdg);        
    }
}
