/**
 * @file lidar_tfminiplus.cpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */


#include "BufferedSerial.h"
#include "constantes.hpp"
#include "lidar_tfminiplus.hpp"


// CONSTANTES LIDAR
const char  LIDAR_EXTERNAL_TRIGGER[] = { 0x42, 0x57, 0x02, 0x00, 0x00, 0x00, 0x00, 0x41 };
const char  LIDAR_GI_CONFIGURATION[] = { 0x42, 0x57, 0x02, 0x00, 0x00, 0x00, 0x01, 0x02 };
const char  LIDAR_GO_CONFIGURATION[] = { 0x42, 0x57, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02 };
const char  LIDAR_CHANGE_OUTPUT_1S[] = { 0x42, 0x57, 0x02, 0x00, 0xE8, 0x03, 0x00, 0x07 };
const char  LIDAR_SET_DISTANCE_500[] = { 0x42, 0x57, 0x02, 0x00, 0x00, 0x00, 0x03, 0x11 };
const char  LIDAR_SET_EXTERNAL_TRI[] = { 0x42, 0x57, 0x02, 0x00, 0x00, 0x00, 0x00, 0x40 };
const char  TFMINIPLUS_UPDATE_RATE[] = { 0x5A, 0x06, 0x03, 0x00, 0x00, 0x63};
const char  TFMINIPLUS_TRIGGER_EXT[] = { 0x5A, 0x04, 0x04, 0x62};
const int   LIDAR_BYTE0               = 0x59;
const int   DISTANCIA_VACIO           = 450;
const int   DECLARAR_LIDAR_VACIO      = 270;
const int   LIDAR_ERROR               = 900;


/**
 * @brief 
 * Esta función recibe un puerto Buffered Serial de Lidar
       también un char array para almacenar los datos recibidos
 * @param puerto_lidar 
 * @param mybuffer 
 * @return true 
 * @return false 
 */
int leer_lidar(BufferedSerial *puerto_lidar, char mybuffer[18]) {
    int contador = 0;
        while (puerto_lidar->readable()) {
            char incoming_char = puerto_lidar->getc();
            mybuffer[contador] = incoming_char;
            contador++;
        }

    return(contador);
}



/**
 * @brief 
 *      Esta función recibe un CHAR ARRAY y evalua si cumple
        con el protocolo de comunicación de LIDAR
        retorna el valor de distancia expresado en centímetros
 * 
 * @param mybuffer 
 * @param lidar_dist 
 * @return true 
 * @return false 
 */
bool parsear_lidar(char mybuffer[18], int *lidar_dist) {
    bool x = false;

    if ((mybuffer[0] == LIDAR_BYTE0) and (mybuffer[1] == LIDAR_BYTE0)) {
        x= true;
        unsigned int t1 = mybuffer[2]; //Byte3
        unsigned int t2 = mybuffer[3]; //Byte4
        t2 <<= 8;
        t2 += t1;
        *lidar_dist = t2;
    }

    return(x);
}
