/**
 * @file exe_rfid.cpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */


#include "BufferedSerial.h"
#include "constantes.hpp"
#include "f_basicas.hpp"
#include "exe_rfid.hpp"


int leer_rfid(BufferedSerial *puerto_data, char id[256])
{
    /* Esta función se encarga de leer el puerto serial y
    almacenar la respuesta en un buffer de datos de entrada.
    Esta función retorna la cantidad de caracteres leidos*/
    int i = 0;
    
    while (puerto_data -> readable()) {// || (i < 19)) { 
        int incoming_char = puerto_data -> getc();
        id[i] = incoming_char;
        i++;
    }
    id[i] = '\0';    //strcpy(id, tmp_buff);
    
    return(i);
}


extern BufferedSerial   rf_id;
extern DigitalOut       display_DP;  
extern BusOut   display_H;
extern BusOut   display_dM;
extern BusOut   display_uM;
extern BusOut   torreLuz;
extern Serial   pcusb;
extern Serial   gv300;
extern Ticker   ticker_minuto;
extern Timer    t_apagado;
extern Timer    t_ocupado;
extern bool     mostrar_tiempo;
extern char     buffer_antena_ID[];
extern char     antena_trailerID_HEX[];
extern char     actual_trailerID_HEX[];
extern char     skytrack_frame[];
extern int      rfid_respuesta;
extern int      bahia_vacia;
extern int      lidar_vacio;
extern int      comparacion;
extern int      contador_diferentes;
extern int      contador_tramas;
extern int      horas;
extern int      dminutos;
extern int      uminutos;
extern int      tiempo_luz_amarilla;
extern int      tiempo_luz_roja;
extern int      w;

void exe_RFiD() {
    rfid_respuesta = leer_rfid(&rf_id, buffer_antena_ID);
    if (rfid_respuesta == 0)  { // En caso que no se recibe información
        bahia_vacia++;
        if (bahia_vacia == DECLARAR_VACIO) { // Si ha pasado tiempo sin recibir datos de la antena RFiD
            bahia_vacia = 0;             // Para dar más tiempo a que responda la antena.
        }
    } else if  ((rfid_respuesta > 16) && (rfid_respuesta <= 20)) {                          // En caso se recibió información del lector RFiD
        bahia_vacia = lidar_vacio = 0;                                                   // Reiniciar el contador de vacio
        convertir_id(buffer_antena_ID, antena_trailerID_HEX, &rfid_respuesta);
        pcusb.printf("\r\nRFiD[%d]: %s", rfid_respuesta, antena_trailerID_HEX);

        comparacion = strcmp(actual_trailerID_HEX, antena_trailerID_HEX);
        if (comparacion == 0) { // Comparar si se ha recuperado el anterior
            if (!mostrar_tiempo) {
                mostrar_tiempo = true;
                pcusb.printf("\r\nReanudar conteo previo...");
                t_apagado.stop();
                t_apagado.reset();
                display_DP = 1;
                presentar_torre(&VERDE, &torreLuz); // Cambiar a luz verde
                presentar_tiempo(&horas, &dminutos, &uminutos, &display_H, &display_dM, &display_uM); // Configurar a 0 el cronometro
            }
            contador_diferentes = 0;
        } else { // Comparar si es un nuevo cabezal
            contador_diferentes++;                                                  // Incrementar contador de diferentes
            pcusb.printf("\r\nDiferentes: %d", contador_diferentes);

            if (contador_diferentes == DELTA_ID) {
                pcusb.printf("\r\nNuevo ID de cabezal...\r\n");
                mostrar_tiempo = true;
                ticker_minuto.detach();
                t_ocupado.reset(); t_ocupado.start();
                t_apagado.stop();
                ticker_minuto.attach(&actualizar_minuto, 60.0);
                horas = dminutos = uminutos = 0; // Reset las variables del cronometro
                strcpy(actual_trailerID_HEX, antena_trailerID_HEX);
                presentar_torre(&VERDE, &torreLuz); // Cambiar a luz verde
                presentar_tiempo(&horas, &dminutos, &uminutos, &display_H, &display_dM, &display_uM); // Configurar a 0 el cronometro
                display_DP = 1;
                contador_diferentes = 0;

                pcusb.printf("\r\nSemaforo VERDE...");
                pcusb.printf("\r\nTiempo inicia en [0:00]");
                w = tiempo_asignado(actual_trailerID_HEX, &tiempo_luz_amarilla, &tiempo_luz_roja); // Cargar los tiempos de la torre de luz
                if (w == 0) {
                    pcusb.printf("\r\nSin tiempo predeterminado\r\n\r\n");
                } else {
                    pcusb.printf("\r\nSemaforo - Amarillo:%d Rojo:%d\r\n\r\n", tiempo_luz_amarilla, tiempo_luz_roja);
                }

                
                sprintf(skytrack_frame, "%s%s%s%s%s%04X%s",
                        CABECERA_TX, CODIGO_INT, BAY_NEWID, actual_trailerID_HEX, FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
                gv300.printf("%s\r\n", skytrack_frame);
                wait_us(300000);
            }
        }
    } else {
        bahia_vacia = lidar_vacio = 0;
        pcusb.printf("\r\nDescartados %d", rfid_respuesta);
    }
}