/**
 * @file exe_lidar.cpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-24
 * 
 * @copyright Copyright (c) 2021
 * 
 */

#include "BufferedSerial.h"
#include "constantes.hpp"
#include "lidar_tfminiplus.hpp"
#include "f_basicas.hpp"

extern BufferedSerial   lidar;
extern DigitalOut       display_DP;
extern BusOut           torreLuz;
extern BusOut           display_H;
extern BusOut           display_dM;
extern BusOut           display_uM;
extern Serial           pcusb;
extern Serial           gv300;
extern Timer            t_apagado;
extern bool             lidar_respuesta;
extern bool             lidar_valido;
extern bool             mostrar_tiempo;
extern char             skytrack_frame[];
extern char             lidar_rx_frame[];
extern char             actual_trailerID_HEX[];
extern int              lidar_contador_no_ack;
extern int              distancia;
extern int              lidar_vacio;
extern int              contador_diferentes;
extern int              contador_tramas;
extern int              w;

void exe_LIDAR() {
    lidar.write(TFMINIPLUS_TRIGGER_EXT,4);
    wait_us(50000);
    lidar_respuesta = leer_lidar(&lidar, lidar_rx_frame);
    if (lidar_respuesta > 0) {
        lidar_valido = parsear_lidar(lidar_rx_frame, &distancia);
        if (mostrar_tiempo) {
        //lidar.write(LIDAR_EXTERNAL_TRIGGER, 8);
            lidar_contador_no_ack = 0;   
            if (lidar_valido) {
                pcusb.printf("\r\nDistancia: %5d cm", distancia);
                if (distancia>=DISTANCIA_VACIO) {
                    lidar_vacio++;
                } else {
                    lidar_vacio = 0;
                }
            } else { // Respuesta invalida
                pcusb.printf("\r\nLiDAR invalida:\r\n");
                for (w=0;w<lidar_respuesta;w++) {
                    printf("0x%02X ", lidar_rx_frame[w]);
                }
                pcusb.printf("\r\n");
                lidar_vacio++;
            }
        } else { // Sin respuesta de LiDAR. Notificar daño
            lidar_vacio++;
            lidar_contador_no_ack++;
            //pcusb.printf("\r\nLiDAR no responde %d/%d", lidar_contador_no_ack, LIDAR_ERROR);

            // Notificar a plataforma que el LiDar lleva mucho tiempo sin responder.
            if (lidar_contador_no_ack  >= LIDAR_ERROR) {
                pcusb.printf("\r\n%s",BAY_LIDAR);  // Notificación
                sprintf(skytrack_frame, "%s%s%s%s%04X%s",
                        CABECERA_TX,CODIGO_INT,BAY_LIDAR,FIN_CABECERA_TX,contador_tramas,ULTIMO_CARACTER);
                gv300.printf("%s\r\n", skytrack_frame);
                incrementar_trama(&contador_tramas);
                lidar_contador_no_ack = 0;
            }
        }

        if (lidar_vacio == DECLARAR_LIDAR_VACIO) {
            pcusb.printf("\r\nBahia vacia...");  // Notificación
            contador_diferentes = 0;             // Se reinicia el contador de diferentes
            mostrar_tiempo = false;

            pcusb.printf("\r\nSemaforo APAGADO...");
            presentar_torre(&APAGADO_TL, &torreLuz); // Apagar torre de luz
            display_DP = 0;

            pcusb.printf("\r\nCronometro a APAGADO...");
            display_uM.write(DIGITOS[APAGADO_7S]);          // Apagar display de unidades de minuto
            display_dM.write(DIGITOS[APAGADO_7S]);          // Apagar display de decenas de minuto
            display_H.write(DIGITOS[APAGADO_7S]);           // Apagar display de horas

            sprintf(skytrack_frame, "%s%s%s%s%04X%s",
                    CABECERA_TX,CODIGO_INT,BAY_EMPTY,FIN_CABECERA_TX,contador_tramas,ULTIMO_CARACTER);
            gv300.printf("%s\r\n", skytrack_frame);
            incrementar_trama(&contador_tramas);
            t_apagado.reset(); t_apagado.start();           // Se inicia un contador para saber cuanto tiempo ha estado apagado.
            pcusb.printf("\r\nInicia margen de %d segundos para descartar TAG previo...", TIEMPO_RECARGA);
            pcusb.printf("\r\nPrevio: %s\r\n\r\n", actual_trailerID_HEX);
        }
    } else {
        flush_uart_rx(&lidar);
    }
}