/**
 * @file constantes.hpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */



#ifndef __CONSTANTES_HPP
#define __CONSTANTES_HPP


    /* DIRECCIÓN DE BAHÍA */
    extern const int    BAY_ADDRESS;
    extern const char   BAY_RESET[19];
    extern const char   BAY_EMPTY[16];
    extern const char   BAY_NEWID[14];
    extern const char   BAY_LIDAR[22];

    /* DEFINICIÓN DE CONSTANTES PARA GV300 */
    extern const char   CABECERA_TX[19];
    extern const char   CODIGO_INT[9];
    extern const char   FIN_CABECERA_TX[7];
    extern const char   ULTIMO_CARACTER[2];
    extern const char   SEPARADOR[2];

    // CONSTANTES DE PUERTO SERIAL
    extern const int    BUFF_SIZE;
    extern const int    TX_MULTIP;

    // OTRAS CONSTANTES
    extern const int    T_ESPERA_CP;        // mili segundos
    extern const int    T_TX;               // mili segundos
    extern const int    DECLARAR_VACIO;
    extern const int    DELTA_ID;
    extern const int    MINUTO;
    extern const int    TIEMPO_RECARGA;
    extern const int    LIMPIA;
    extern const float  TIME_HEARTBEAT;
    extern const char   ALIVE[11];
    extern const int    MAX_REINTENTOS;

    // DEFINICIÓN PARA DISPLAY DE 7 SEGMENTOS
    extern const int DIGITOS[11];
    extern const int COLOR_TORRE_LUZ[4];
    extern const int APAGADO_TL;
    extern const int VERDE;
    extern const int AMARILLO;
    extern const int ROJO;
    extern const int CERO_7S;
    extern const int UNO_7S;
    extern const int DOS_7S;
    extern const int TRES_7S;
    extern const int CUATRO_7S;
    extern const int CINCO_7S;
    extern const int SEIS_7S;
    extern const int SIETE_7S;
    extern const int OCHO_7S;
    extern const int NUEVE_7S;
    extern const int APAGADO_7S;

#endif // __CONSTANTES_HPP