/**
 * @file constantes.cpp
 * @author Felícito Manzano (felicito.manzano@detektor.com.sv)
 * @brief 
 * @version 0.1
 * @date 2021-05-23
 * 
 * @copyright Copyright (c) 2021
 * 
 */


#include "constantes.hpp"

/* DIRECCIÓN DE BAHÍA */
#define BAY_NUMBER  4

const int BAY_ADDRESS = BAY_NUMBER;

#if (BAY_NUMBER == 1)
    const char  ALIVE[]         = "Bahia 1-OK";         //"@BAY1-OK#";
    const char  BAY_RESET[]     = "Bahia 1-Reinicio";   //"@BAY1-REBOOT#"
    const char  BAY_EMPTY[]     = "Bahia 1-Vacia";      //"@BAY1-EMPTY#";
    const char  BAY_NEWID[]     = "Bahia 1-TAG:";       //"@BAY1-ID:";
    const char  BAY_LIDAR[]     = "Bahia 1-LiDAR Error"; 
#elif (BAY_NUMBER == 2)
    const char  ALIVE[]         = "Bahia 2-OK";         //"@BAY1-OK#";
    const char  BAY_RESET[]     = "Bahia 2-Reinicio";   //"@BAY1-REBOOT#"
    const char  BAY_EMPTY[]     = "Bahia 2-Vacia";      //"@BAY1-EMPTY#";
    const char  BAY_NEWID[]     = "Bahia 2-TAG:";       //"@BAY1-ID:";
    const char  BAY_LIDAR[]     = "Bahia 2-LiDAR Error";
#elif (BAY_NUMBER == 3)
    const char  ALIVE[]         = "Bahia 3-OK";         //"@BAY1-OK#";
    const char  BAY_RESET[]     = "Bahia 3-Reinicio";   //"@BAY1-REBOOT#"
    const char  BAY_EMPTY[]     = "Bahia 3-Vacia";      //"@BAY1-EMPTY#";
    const char  BAY_NEWID[]     = "Bahia 3-TAG:";       //"@BAY1-ID:";
    const char  BAY_LIDAR[]     = "Bahia 3-LiDAR Error";
#elif (BAY_NUMBER == 4)
    const char  ALIVE[]         = "Bahia 4-OK";         //"@BAY1-OK#";
    const char  BAY_RESET[]     = "Bahia 4-Reinicio";   //"@BAY1-REBOOT#"
    const char  BAY_EMPTY[]     = "Bahia 4-Vacia";      //"@BAY1-EMPTY#";
    const char  BAY_NEWID[]     = "Bahia 4-TAG:";       //"@BAY1-ID:";
    const char  BAY_LIDAR[]     = "Bahia 4-LiDAR Error";
#else
    const char  ALIVE[]         = "Bahia 5-OK";         //"@BAY1-OK#";
    const char  BAY_RESET[]     = "Bahia 5-Reinicio";   //"@BAY1-REBOOT#"
    const char  BAY_EMPTY[]     = "Bahia 5-Vacia";      //"@BAY1-EMPTY#";
    const char  BAY_NEWID[]     = "Bahia 5-TAG:";       //"@BAY1-ID:";
    const char  BAY_LIDAR[]     = "Bahia 5-LiDAR Error";
#endif

/* DEFINICIÓN DE CONSTANTES PARA GV300 */
const char CABECERA_TX[]        = "AT+GTDAT=gv300,2,,";
const char CODIGO_INT[]         = "TCA|505|";
const char FIN_CABECERA_TX[]    = ",0,,,,";
const char ULTIMO_CARACTER[]    = "$";
const char SEPARADOR[]          = ";";

// CONSTANTES DE PUERTO SERIAL
const int   BUFF_SIZE   = 498;
const int   TX_MULTIP   = 1;

// OTRAS CONSTANTES
const int   T_ESPERA_CP     = 300000;  // micro segundos
const int   T_TX            = 10000;   // micro segundos
const int   DECLARAR_VACIO  = 3600;  // Segundos para declarar que la bahía está vacia
const int   DELTA_ID        = 15;
const int   MAX_REINTENTOS  = 4;
const int   MINUTO          = 60;           // Un minuto = 60 segundos
const int   TIEMPO_RECARGA  = 7200;         // dos horas = 7200
const int   LIMPIA          = 10800;        // Tres horas = 10800 segundos
const float TIME_HEARTBEAT  = 1800.0;

// DEFINICIÓN PARA DISPLAY DE 7 SEGMENTOS
// DEFINICIÓN PARA ANODO COMÚN
/*
const int DIGITOS[11] = { // G, F, E, D, C, B, A --> Invertido para BusOut
                          0x40, // CERO     (1000000)
                          0x79, // UNO      (1111001)
                          0x24, // DOS      (0100100)
                          0x30, // TRES     (0110000)
                          0x19, // CUATRO   (0011001)
                          0x12, // CINCO    (0010010)
                          0x02, // SEIS     (0000010)
                          0x78, // SIETE    (1111000)
                          0x00, // OCHO     (0000000)
                          0x10, // NUEVE    (0010000)
                          0x7F  // APAGADO CON 10   (1111111)
                         };
                         */

// CATODO COMÚN
const int DIGITOS[11] = { // G, F, E, D, C, B, A --> Invertido para BusOut
                          0x3F, // {0111111},  // CERO
                          0x06, // {0000110},  // UNO
                          0x5B, // {1011011},  // DOS
                          0x4F, // {1001111},  // TRES
                          0x66, // {1100110},  // CUATRO
                          0x6D, // {1101101},  // CINCO
                          0x7D, // {1111101},  // SEIS
                          0x07, // {0000111},  // SIETE
                          0x7F, // {1111111},  // OCHO
                          0x6F, // {1101111},  // NUEVE
                          0x00  // {00000000}   // APAGADO CON 10
                         };


const int COLOR_TORRE_LUZ[4] = { // ROJO, AMARILLO, VERDE --> Invertido para BusOut
                         0x00, // {0, 0, 0}, // APAGADO CON 0
                         0x01, // {0, 0, 1}, // VERDE
                         0x02, // {0, 1, 0}, // AMARILLLO
                         0x04  // {1, 0, 0} // ROJO
                        };

const int APAGADO_TL        = 0;
const int VERDE             = 1;
const int AMARILLO          = 2;
const int ROJO              = 3;
const int CERO_7S           = 0;
const int UNO_7S            = 1;
const int DOS_7S            = 2;
const int TRES_7S           = 3;
const int CUATRO_7S         = 4;
const int CINCO_7S          = 5;
const int SEIS_7S           = 6;
const int SIETE_7S          = 7;
const int OCHO_7S           = 8;
const int NUEVE_7S          = 9;
const int APAGADO_7S        = 10;