/*
The <sys/time.h> header defines the timeval structure that includes at least the following members:

time_t         tv_sec      seconds
suseconds_t    tv_usec     microseconds

#define time_t unsigned int
*/
#define suseconds_t unsigned int

struct timeval {
    time_t tv_sec;
    suseconds_t tv_usec;
};

void resetcpu( void );
void run_cpu( void );

void waitforevents(struct timeval *);
void checkevents( void );
void redrawlcd( void );
void vmputpixel(int, int, int);
void keypress(int i);
void keyrelease(int i);
int do_vmsgame(char *filename, char *biosname);
int do_lcdimg(char *filename);
void sound(int freq);
int gettimeofday(struct timeval *);
#define GETTIMEOFDAY(tp) gettimeofday(tp)
extern void error_msg(char *fmt, ...);

