#include "Pokitto.h"
#include "mbed.h"
#include "prototypes.h"

volatile uint32_t *DBG = ((uint32_t *) 0x21000000);

Pokitto::Core pok;
time_t start;

int main () {
    DBG[1] = 1; // 2|4;
    // DBG[2] = 5;
    
    pok.begin();
    start = time(NULL);
    Pokitto::Display &display = pok.display;

    display.enableDirectPrinting(true);
    display.directbgcolor = COLOR_BLACK;
    display.directcolor = COLOR_GREEN;
    display.clearLCD();
    
    resetcpu();
    run_cpu();
    
}

void waitforevents(struct timeval *){
}

uint32_t keyState;

void checkevents()
{
  uint32_t bit = 1;
  
  Pokitto::Core::buttons.pollButtons();  
  uint32_t nks = Pokitto::Core::buttons.buttons_state;
  
    if( nks & (1<<UPBIT) ){ // UP
      if( !(keyState&bit) ) {
        keyState |= bit;
        keypress(0);
      }
    }else if( keyState & bit ){
      keyState &= ~bit;
      keyrelease(0);
    }
    bit <<= 1;

    if( nks & (1<<DOWNBIT) ){ // UP
      if( !(keyState&bit) ) {
        keyState |= bit;
        keypress(1);
      }
    }else if( keyState & bit ){
      keyState &= ~bit;
      keyrelease(1);
    }
    bit <<= 1;

    if( nks & (1<<LEFTBIT) ){ // UP
      if( !(keyState&bit) ) {
        keyState |= bit;
        keypress(2);
      }
    }else if( keyState & bit ){
      keyState &= ~bit;
      keyrelease(2);
    }
    bit <<= 1;

    if( nks & (1<<RIGHTBIT) ){ // UP
      if( !(keyState&bit) ) {
        keyState |= bit;
        keypress(3);
      }
    }else if( keyState & bit ){
      keyState &= ~bit;
      keyrelease(3);
    }
    bit <<= 1;

    if( nks & (1<<ABIT) ){ // UP
      if( !(keyState&bit) ) {
        keyState |= bit;
        keypress(4);
      }
    }else if( keyState & bit ){
      keyState &= ~bit;
      keyrelease(4);
    }
    bit <<= 1;

    if( nks & (1<<BBIT) ){ // UP
      if( !(keyState&bit) ) {
        keyState |= bit;
        keypress(5);
      }
    }else if( keyState & bit ){
      keyState &= ~bit;
      keyrelease(5);
    }
    bit <<= 1;

  
}


void redrawlcd(){
}

void vmputpixel( int x, int y, int c ){
    // Pokitto::Core::display.directPixel( x, y, c&1 ? COLOR_WHITE : COLOR_GREEN );
    Pokitto::lcdRectangle( 14+(x<<2), 10+(y<<2), 14+((x+1)<<2), 10+((y+1)<<2), c&1 ? COLOR_GRAY_15 : COLOR_GRAY_225 );

}

void sound(int freq){
}

int gettimeofday( struct timeval *tm ){
    uint32_t t = pok.getTime();
    tm->tv_sec = start + t/1000;
    tm->tv_usec = start + t*10;
    return 0;
}

void error_msg(char *fmt, ...){
}
