
#include "mbed.h"
#define CANT_PULSADORES 2
Serial pc(USBTX, USBRX);
Ticker tick;
BusOut leds(D10,D9,D8,D6,D5,D4,D3,D2);
DigitalOut A_D(PTB8);
DigitalOut B_D(PTB9);
DigitalOut C_D(PTB10);
DigitalOut D_D(PTB11);
DigitalOut E_D(PTE2);
DigitalOut F_D(PTE3);
DigitalOut G_D(PTE4);
DigitalOut CAT(PTE5);
BusIn pulsadores (D12,D11);
int tiempo=0;
int tiempo2=0;
int valor = 0;
int display=1;
void funcion();
void flip()
{
    funcion(); //coloco acà la funciòn para que se ejecute todo el tiempo
    if(tiempo<=50000) {
        tiempo++;
    }
    if(tiempo2<=800) {
        tiempo2++;
    }
}
int Led_Step(); // declaro las funciones
void Maquina_General(void);
void inicio();
void ganador();
int main()
{
    tick.attach(&flip, 0.01);
    pulsadores[0].mode(PullNone);
    pulsadores[1].mode(PullNone);
    while (true) {
        Maquina_General();
    }
}
///
void Maquina_General(void)
{
    static int estado_A = 0;
    static int led_actual = 0;
    static int puntos_a = 0,puntos_b = 0; // lo pongo static porque sino me cambia el valor de los puntos
    int a=0, b=0;
    switch(estado_A) {
        case 0:
            inicio();
            if(pulsadores[0] == 1 && pulsadores[1] == 1) {

                estado_A = 1; //se prende el sistema
                puntos_a = 0;
                puntos_b = 0;
                tiempo=0;
            }
            break;
        case 1: //estado jugador 1
            Led_Step();
            if(tiempo>=20) { //pequeña demora para evitar problemas
                if(pulsadores[0] == 1 ) {
                    leds=0;
                    led_actual = Led_Step(); //valor de estado de funcion Led_Step()
                    if (led_actual==8) //en caso que sea el segundo sentido y asi detectar el led en el que paro
                        a=2;
                    if (led_actual==9)
                        a=4;
                    if (led_actual==10)
                        a=6;
                    if (led_actual==11)
                        a=8;
                    if (led_actual==12)
                        a=10;
                    if (led_actual==13)
                        a=12;
                    if(led_actual > 7) {
                        led_actual = led_actual - a; // coloco esta variable en su led perteneciente
                    }
                    leds[led_actual]=1; //2 segundos prendido
                    if(led_actual == 7) {
                        puntos_a= puntos_a + 10;
                        printf("el jugador 1 suma un punto\n");
                        leds[0]=1;
                        leds[1]=1;
                        leds[2]=1;
                        leds[3]=1;
                        leds[4]=1;
                        leds[5]=1;
                        leds[6]=1;
                        leds[7]=1;
                    } // sumo 10 puntos para luego en el multuplexado poder usar los 2 displays juntos
                    valor = puntos_a + puntos_b; // valor que le llega al barrido
                    estado_A = 3; // paso a la espera
                    tiempo2=0; // hago que vuelva a contar el tiempo 2
                }
            }
            break;
        case 2: //estado jugador 2
            Led_Step();
            if(pulsadores[1] == 1 ) {
                leds=0;
                led_actual = Led_Step(); //valor de estado de funcion Led_Step()
                if (led_actual==8)
                    b=2;
                if (led_actual==9)
                    b=4;
                if (led_actual==10)
                    b=6;
                if (led_actual==11)
                    b=8;
                if (led_actual==12)
                    b=10;
                if (led_actual==13)
                    b=12;
                if(led_actual > 7) {
                    led_actual = led_actual - b;
                }
                leds[led_actual]=1; //2 segundos
                if(led_actual == 0) {
                    puntos_b++;
                    printf("el jugador 2 suma un punto\n");
                    leds[0]=1;
                    leds[1]=1;
                    leds[2]=1;
                    leds[3]=1;
                    leds[4]=1;
                    leds[5]=1;
                    leds[6]=1;
                    leds[7]=1;
                }
                valor = puntos_a + puntos_b;
                estado_A = 4;
                tiempo2=0;
            }
            break;
        case 3: // Espero tiempo pausado jugador 1
            if(tiempo2==200) {
                leds[led_actual]=0;
                estado_A = 2;
                if(puntos_a >= 50) {
                    estado_A = 0; // vuelvo al inicio asi en caso de que se desee se vuelva a iniciar el juego
                    puntos_a=0; // vuelvo todo a cero por las dudas
                    puntos_b=0;
                    valor=0;
                    printf("el jugaror 1 gana\n");
                }
                tiempo=0;
            }
            break;
        case 4: // Espero tiempo pausado jugador 2
            if(tiempo2==200) {
                leds[led_actual]=0;
                estado_A = 1;
                if(puntos_b >= 2) {
                    estado_A = 0;
                    puntos_a=0;
                    puntos_b=0;
                    valor=0;
                    printf("el jugaror 2 gana\n");
                }
                tiempo=0;
            }
            break;
    }
}
///
int Led_Step(void) // funcion de secuencia ida y vuelva
{
    static int estado = 0;
    switch(estado) {
        case 0:
            leds = 0;
            leds[0] = 1; //suma un punto jugador 2
            if(tiempo == 5) { // 0.05 SEG
                estado = 1;
            }
            break;
        case 1:
            leds=0;
            leds[1] = 1;
            if(tiempo == 10) {
                estado = 2;
            }
            break;
        case 2:
            leds=0;
            leds[2] = 1;
            if(tiempo == 15) {
                estado = 3;
            }
            break;
        case 3:
            leds=0;
            leds[3] = 1;
            if(tiempo == 20) {
                estado = 4;
            }
            break;
        case 4:
            leds=0;
            leds[4] = 1;
            if(tiempo == 25) {
                estado = 5;
            }
            break;
        case 5:
            leds=0;
            leds[5] = 1;
            if(tiempo == 30) {
                estado = 6;
            }
            break;
        case 6:
            leds=0;
            leds[6] = 1;
            if(tiempo == 35) {
                estado = 7;
            }
            break;
        case 7:
            leds=0;
            leds[7] = 1; //suma un punto jugador 1
            if(tiempo == 40) {
                estado = 8;
            }
            break;
        case 8:
            leds=0;
            leds[6] = 1;
            if(tiempo == 45) {
                estado = 9;
            }
            break;
        case 9:
            leds=0;
            leds[5] = 1;
            if(tiempo == 50) {
                estado = 10;
            }
            break;
        case 10:
            leds=0;
            leds[4] = 1;
            if(tiempo == 55) {
                estado = 11;
            }
            break;
        case 11:
            leds=0;
            leds[3] = 1;
            if(tiempo == 60) {
                estado = 12;
            }
            break;
        case 12:
            leds=0;
            leds[2] = 1;
            if(tiempo == 65) {
                estado = 13;
            }
            break;
        case 13:
            leds=0;
            leds[1] = 1;
            if(tiempo == 70) {
                estado = 0;
                tiempo=0;
            }
            break;
    }
    return estado;
}
///
void inicio(void) // funcion de espera antes que se inicie el juego
{
    static int est = 0;
    switch(est) {
        case 0:
            leds = 0;
            leds[0] = 1;
            if(tiempo == 100) { //1 seg
                est = 1;
            }
            break;
        case 1:
            leds=0;
            leds[1] = 1;
            if(tiempo == 200) {
                est = 2;
            }
            break;
        case 2:
            leds=0;
            leds[2] = 1;
            if(tiempo == 300) {
                est = 3;
            }
            break;
        case 3:
            leds=0;
            leds[3] = 1;
            if(tiempo == 400) {
                est = 4;
            }
            break;
        case 4:
            leds=0;
            leds[4] = 1;
            if(tiempo == 500) {
                est = 5;
            }
            break;
        case 5:
            leds=0;
            leds[5] = 1;
            if(tiempo == 600) {
                est = 6;
            }
            break;
        case 6:
            leds=0;
            leds[6] = 1;
            if(tiempo == 700) {
                est = 7;
            }
            break;
        case 7:
            leds=0;
            leds[7] = 1;
            if(tiempo == 800) {
                est=0;
                tiempo = 0;
            }
            break;
    }
}
///
void funcion () // funcion de barrido multiplexado
{
    int numeros[10]= {0b1111110, 0b0110000, 0b1101101, 0b1111001, 0b0110011, 0b1011011, 0b1011111, 0b1110000, 0b1111111, 0b1111011};
    int d1;
    if(display==0) //ponemos estas 2 cuentas para distinto display y asi cambiarlo en cada catodo, por esto es que los puntos a se suman de a 10
        d1 = valor/10;
    else
        d1 = valor%10;

    A_D = (numeros[d1] & 0b1000000) >> 6;
    B_D = (numeros[d1] & 0b100000) >> 5;
    C_D = (numeros[d1] & 0b10000) >> 4;
    D_D = (numeros[d1] & 0b1000) >> 3;
    E_D = (numeros[d1] & 0b100) >> 2;
    F_D = (numeros[d1] & 0b10) >> 1;
    G_D = numeros[d1] & 1;

    display ? display = 0 : display = 1; //cambio el display
    CAT=display; // asigno ese cambio al cátodo
}



