
#ifndef __TINY_BLE_H__
#define __TINY_BLE_H__
#define LED_GREEN   p21
#define LED_RED     p22
#define LED_BLUE    p23
#define BUTTON_PIN  p17
#define BATTERY_PIN p1

#define MPU6050_SDA p12
#define MPU6050_SCL p13

#define UART_TX     p9
#define UART_RX     p11
#define UART_CTS    p8
#define UART_RTS    p10


#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif
#ifndef round
#define round(var)    (int)(var+0.5f)
#endif

#define DEFAULT_MPU_HZ  (200)

// FIFO rate = 200Hz / (1 + this value)
// For example, 0x01 is 100Hz, 0x03 is 50Hz.
// 0x00 to 0x09
#define IMU_FIFO_RATE_DIVIDER 0x09

// Sample rate = 1kHz / (1 + this valye)
// For example, 4 is 200Hz.
#define IMU_SAMPLE_RATE_DIVIDER 4

// measuring range of gyroscope (±n deg/s)
// But other value doesn't yet support.
#define MPU6050_GYRO_FS MPU6050_GYRO_FS_2000

// measuring range of acceleration sensor (±n g)
// But other value doesn't yet support.
#define MPU6050_ACCEL_FS MPU6050_ACCEL_FS_2

#define PC_BAUDRATE 921600
#endif // __TINY_BLE_H__

