/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *

 *
 *
 */

#include "MPUService.h"

const uint8_t  MPUServiceBaseUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, 0x8D, 0xC0, 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};
const uint16_t MPUServiceShortUUID                      = 0x8DC0;

const uint16_t MPUServiceYPRCharacteristicShortUUID    = 0x8DC1;

const uint16_t MPUServiceAccelCharacteristicShortUUID   = 0x8DC2;
const uint16_t MPUServiceQuatCharacteristicShortUUID    = 0x8DC3;
const uint16_t MPUServiceTimeCharacteristicShortUUID    = 0x8DC4;
const uint16_t MPUServiceSettingCharacteristicShortUUID = 0x8DC5;

const uint8_t MPUServiceUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, (uint8_t)(MPUServiceShortUUID >> 8), (uint8_t)(MPUServiceShortUUID & 0xFF), 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};

const uint8_t  MPUServiceUUID_reversed[LENGTH_OF_LONG_UUID] = {
    0x66, 0x9A, 0x0C, 0x20, 0x00, 0x08, 0x39, 0xB9,
    0xE5, 0x11, 0x91, 0x0E, (uint8_t)(MPUServiceShortUUID & 0xFF), (uint8_t)(MPUServiceShortUUID >> 8), 0x88, 0xD9
};

const uint8_t  MPUServiceYPRCharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, (uint8_t)(MPUServiceYPRCharacteristicShortUUID >> 8), (uint8_t)(MPUServiceYPRCharacteristicShortUUID & 0xFF), 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};

const uint8_t  MPUServiceAccelCharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, (uint8_t)(MPUServiceAccelCharacteristicShortUUID >> 8), (uint8_t)(MPUServiceAccelCharacteristicShortUUID & 0xFF), 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};

const uint8_t  MPUServiceQuatCharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, (uint8_t)(MPUServiceQuatCharacteristicShortUUID >> 8), (uint8_t)(MPUServiceQuatCharacteristicShortUUID & 0xFF), 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};

const uint8_t  MPUServiceTimeCharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, (uint8_t)(MPUServiceTimeCharacteristicShortUUID >> 8), (uint8_t)(MPUServiceTimeCharacteristicShortUUID & 0xFF), 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};    

const uint8_t  MPUServiceSettingCharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0xD9, 0x88, (uint8_t)(MPUServiceSettingCharacteristicShortUUID >> 8), (uint8_t)(MPUServiceSettingCharacteristicShortUUID & 0xFF), 0x0E, 0x91, 0x11, 0xE5,
    0xB9, 0x39, 0x08, 0x00, 0x20, 0x0C, 0x9A, 0x66
};    

    
