#include <cmath>
#include "IRSensor.h"

using namespace std;

IRSensor::IRSensor(AnalogIn& distance, DigitalOut& bit0, DigitalOut& bit1,
                    DigitalOut& bit2, int number)   :
                    distance(distance), bit0(bit0), bit1(bit1), bit2(bit2) {
                        
                        this->number = number;
   }
   
   IRSensor::~IRSensor() {}
   
   float IRSensor::read() {
       
       bit0 = (number >>0) & 1;
       bit1 = (number >>1) & 1;
       bit2 = (number >>2) & 1; 
       
       float d = -0.58f*sqrt(distance)+0.58f; //Lesen der Distanz in Meter
       
       return d;
       
       }