#include <mbed.h>
#include "IRSensor.h"
#include "Controller.h"
#include "EncoderCounter.h"
#include "LowpassFilter.h"
    
    DigitalOut enable(PC_1);
    DigitalOut led0(PC_8);
    DigitalOut led1(PC_6);
    DigitalOut led2(PB_12);
    DigitalOut led3(PA_7);
    DigitalOut led4(PC_0);
    DigitalOut led5(PC_9);
    
    DigitalOut enableMotorDriver(PB_2);
    
    DigitalIn motorDriverFault(PB_14);
    DigitalIn motorDriverWarning(PB_15);
    
    PwmOut pwmLeft(PA_8);
    PwmOut pwmRight(PA_9);
    
    EncoderCounter counterLeft(PB_6, PC_7);
    EncoderCounter counterRight(PA_6, PC_7);
    
    Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);
        
    AnalogIn distance(PB_1); //Kriterien der Ein- und Ausgabeobjekte
    DigitalOut bit0(PH_1);
    DigitalOut bit1(PC_2);
    DigitalOut bit2(PC_3);
    
    IRSensor irSensor0(distance, bit0, bit1, bit2, 0);
    IRSensor irSensor1(distance, bit0, bit1, bit2, 1);
    IRSensor irSensor2(distance, bit0, bit1, bit2, 2);
    IRSensor irSensor3(distance, bit0, bit1, bit2, 3);
    IRSensor irSensor4(distance, bit0, bit1, bit2, 4);
    IRSensor irSensor5(distance, bit0, bit1, bit2, 5);
    
    int main() {
        
        enable = 1;
        
        controller.setDesiredSpeedLeft(10.0f);
        controller.setDesiredSpeedRight(-10.0f);
        enable=1;
        enableMotorDriver = 1;    
        
       while(1) {
            float distance0 = irSensor0.read();
            float distance1 = irSensor1.read();
            float distance2 = irSensor2.read();
            float distance3 = irSensor3.read();
            float distance4 = irSensor4.read();
            float distance5 = irSensor5.read();
            
            wait(0.1f); //100ms
            
            
            if (irSensor0.read() < 0.2f) led0 =1;
            else led0 =0; 
            if (irSensor1.read() < 0.2f) led1 =1;
            else led0 =0; 
            if (irSensor2.read() < 0.2f) led2 =1;
            else led0 =0; 
            if (irSensor3.read() < 0.2f) led3 =1;
            else led0 =0; 
            if (irSensor4.read() < 0.2f) led4 =1;
            else led0 =0; 
            if (irSensor5.read() < 0.2f) led5 =1;
            else led0 =0; 
        } 
    }
    