#include "mbed.h"
#include "DHT.h"
#include "TextLCD.h"

Serial device(PA_2,PA_3);
DHT sensor(PD_7, DHT22);
I2C i2c_lcd(PB_9, PB_8); // SDA, SCL
//TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);

int main()
{
    //lcd.cls();
    //lcd.setBacklight(TextLCD::LightOn);
    //lcd.setCursor(TextLCD::CurOff_BlkOff);
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;

    while(1) {
       wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            device.baud(115200);
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            //lcd.locate(0,0);
            //lcd.printf("Temperature in Kelvin: %2.1f, Celcius: %2.1f, Farenheit %2.1f\n", k, c, f);
            device.printf("Temperature in Kelvin: %2.1f, Celcius: %2.1f, Farenheit %2.1f\n", k, c, f);
            device.printf("Humidity is %2.1f, Dewpoint: %2.1f, Dewpoint fast: %2.1f\n", h, dp, dpf);
            device.printf("\n");
        } else {
            device.printf("Error: %d\n", error);
        }
    }
}
/*

DigitalOut myled(LED1);

void DHT(){
    DHT
}

int main() {
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
*/
