
#include "mbed.h"
#include "DHT.h"
Serial device(PA_2,PA_3);
DHT sensor(PD_7, DHT22);

int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;

    while(1) {
       wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            device.baud(115200);
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            device.printf("Temperature in Kelvin: %2.1f, Celcius: %2.1f, Farenheit %2.1f\n", k, c, f);
            device.printf("Humidity is %2.1f, Dewpoint: %2.1f, Dewpoint fast: %2.1f\n", h, dp, dpf);
            device.printf("\n");
        } else {
            device.printf("Error: %d\n", error);
        }
    }
}
