#include "mbed.h"
#include "DataFile.h"

#include "SDFileSystem.h"
#include "COMPASS_DISCO_L476VG.h"
#include "GYRO_DISCO_L476VG.h"
#define NbDAC   5

#define SavePeriod  0.1     // 1/frequency of log : default 0.1 (tested OK at 0.01 (100Hz))

DigitalOut LedEnreg(LED1);
DigitalIn InterEnreg(PD_0,PullDown);
Ticker TickUpdate;
COMPASS_DISCO_L476VG  compass ; //declaration must be before SDFile system declaration
GYRO_DISCO_L476VG gyro;



AnalogIn AIn0(PA_0);
AnalogIn AIn1(PA_1);
AnalogIn AIn2(PA_2);
AnalogIn AIn3(PA_3);
AnalogIn AIn4(PA_5);

AnalogIn * TabpAIn[NbDAC]= {&AIn0,&AIn1,&AIn2,&AIn3,&AIn4};
//AnalogIn * AIn [5];

  //Create an SDFileSystem object
SDFileSystem sd(PE_15, PE_14, PE_13, PE_12, "sd");


tDataFile DataFile; //used to manage data savings
bool EnregistrementEnCours;
 
tMesure Mesures(&compass,&gyro,TabpAIn);



//------------------------
// manage log switch
void CheckEnreg()
{
   if (InterEnreg.read()==1)
    {
       if (!EnregistrementEnCours)
       {
           EnregistrementEnCours=true;
           DataFile.New();
           printf("log started\n\r"); 
       } 
       else
       {
           DataFile.SaveMesures(&Mesures);
       }
       LedEnreg=!LedEnreg;
       
    }
    else
    { 
       if (EnregistrementEnCours)
       {
           EnregistrementEnCours=false;
           DataFile.Close();
           printf("Log stopped\n\r"); 
       } 
       LedEnreg=0;
    }
}

/***********************
Main function in loop
************************/
void Update()
{
   CheckEnreg();  
   Mesures.Update();
}

//------------------------
// initialization of logger
 
void Init()
{
   TickUpdate.attach(&Update, SavePeriod);  //starting the infinit loop
   printf("\n\r");
   printf("DISCO logger V2.0\n\r");
   printf("----------------\n\r\n\r");
   
   EnregistrementEnCours=false;
   LedEnreg=0;
   
   printf("sensors started\n\r"); 
   
   //Mount the filesystem
   sd.mount();   
   printf("File system mounted\n\r"); 
   printf("Toggle switch to start recording\n\r");
   
  /* AIn[0]=&AIn0;
   AIn[1]=&AIn1;
   AIn[2]=&AIn2;
   AIn[3]=&AIn3;
   AIn[4]=&AIn4;*/
}