#include "mbed.h"
#include "COMPASS_DISCO_L476VG.h"
#include "GYRO_DISCO_L476VG.h"

#ifndef MESURE_H
#define MESURE_H
#define NbDAC   5
/*---------------------------------------------
Manage acquisitions
    Compass
    Acceleration
    Gyroscope
    
 !!!   calibration to be defined in the constructor !!!

*/

class tMesure
{
public:
tMesure(COMPASS_DISCO_L476VG * apCompass, GYRO_DISCO_L476VG * apGyro, AnalogIn * apAIn[NbDAC]);
 
void Update();  
void Save(FILE * apFile); 

private:
    COMPASS_DISCO_L476VG * pCompass;
    GYRO_DISCO_L476VG * pGyro;
    
    double Mag[3];
    double Acc[3];
    double Omega[3];
    double AIO[NbDAC];
    
    double OffsetMag[3];
    double OffsetAcc[3];
    double OffsetOmega[3];
    double OffsetAIO[NbDAC];
    
    double GainMag[3];
    double GainAcc[3];
    double GainOmega[3];
    double GainAIO[NbDAC];
    
    AnalogIn * pAIn[NbDAC];
    
};
#endif