/*DCF77 Digitale Clock V1.0 by hans.oostwal@kpnmail.nl

PARTS:
Conrad DCF77 receiver.
Nokia 6610 graphic 130x130 display on breakout board Olimex.
Mbed NXP LCP768.
Resisor 2K2 1/4W.
-------------------------------------
CONNECTIONS:
DCF77 Receiver:
pin_1=GND.
pin_2=+5V use the not inverted output.
pin_3=non inverted open collector output via pullup resistor 2K2 to pin DigitalInput pin_21 Mbed.
pin_4=inverted output not used.
-------------------------------------
CONNECTIONS:
LCD Nokia 6610 Display 130x130 Olimex compatiple:
PIN_5 mosi
PIN_7 sclk
PIN_8 cs
PIN_9 rst
*/



#include "mbed.h"
#include "NokiaLCD.h"

//harware_conections
DigitalOut testu (LED4);//pariteit error hour
DigitalOut testm (LED4);//pariteit error minute
DigitalOut testdmy (LED4);//pariteit error day/month/year


DigitalOut err_led(LED3);//syncronize error
DigitalOut sign_bit_1(LED1);//received DCF bit=1
DigitalOut sign_bit_0(LED2);//received DCF bit=0


DigitalIn dcf_in(p21);//conection of output(Conrad)NON inverting dcf module, (opencollecter use pullup resistor of 2K2).
Serial pc(USBTX,USBRX);//usb serial connection

//connectons LCD Nokia Graphic Olimex display


NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst,: type



//variabele
char parall, paritym,parityu,paritydmy;
char bit;
char sec,lcd_sec,a_sec;
char teller;
char min,minh,minl;
char loop_i;
char uurh,uurl,uur;
char w_dag;
char dag,dagh,dagl;
char maand,maandh,maandl;
char jaar,jaarh,jaarl;
char wait_sync;
char wait_balk;
char summertime;


int dcf_array[61];

//makro,s
void sync ();
void getbit ();
void lcd_txt ();
void name_weekdag();
void name_month();


//START MAIN
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int main() { //start main_ program

    wait_sync=120;

//welcome text    
    
    lcd.locate (1,3);
    lcd.printf("Start DCF V1.0");
    lcd.locate(0,5);
    lcd.printf("hans.oostwal    @kpnmail.nl");
    wait (5);
    lcd.cls();

    while (1) { //1e_loop

        //wait for dcf signal
        lcd.locate (0,3);
        lcd.printf("wait for 59e bit");
        lcd.locate(0,1);
        lcd.printf("DCF start signal");

        parall=0;
        sec=0;
        err_led=1;
        dcf_array[58] = 0;
        loop_i = 0;
        sign_bit_0 = 0;
        sign_bit_1 = 0;

        while (1) { //2e_loop

            sync ();
            err_led=0;

            while (1) { //3e_loop

                teller=0;

                teller++;

                while (teller<59) {
                    getbit();//JUMP TO MAKRO GETBIT
                    lcd_txt();//JUMP TO MAKRO LCD_TXT
                    teller++;
                }

                sec=58;
                sync ();
                sec=59;
                lcd_txt ();//JUMP TO MAKRO lcd_txt
                getbit ();

//calculate summer/winter time----------------------------------------------------------------------
                summertime = dcf_array[17] & 1;


//----------------------------------------------------------------------------------------------------


//calculate uur--------------------------------------------------------------------------------------
                uurh = dcf_array[34] * 20 + dcf_array[33] * 10;
                uurl = dcf_array[32] * 8 + dcf_array[31] * 4 + dcf_array[30] * 2 + dcf_array[29] * 1;
                uur = uurh + uurl;
//----------------------------------------------------------------------------------------------------

//calculate minutes------------------------------------------------------------------------------------
                minl = dcf_array[24] * 8 + dcf_array[23] * 4 + dcf_array[22] * 2 + dcf_array[21] * 1;
                minh = dcf_array[27] * 40 + dcf_array[26] * 20 +dcf_array[25] * 10;
                min = minh + minl;
//-----------------------------------------------------------------------------------------------------

//calculate day of week--------------------------------------------------------------------------------
                w_dag = dcf_array[44] * 4 +dcf_array[43] * 2 + dcf_array[42] * 1;

//-----------------------------------------------------------------------------------------------------

//calculate day----------------------------------------------------------------------------------------
                dagl = dcf_array[39] * 8 + dcf_array[38] * 4 + dcf_array[37] * 2 + dcf_array[36] * 1;
                dagh = dcf_array[41] * 20 + dcf_array[40] * 10;
                dag=dagh+dagl;

//calculate month--------------------------------------------------------------------------------------
                maandh = dcf_array[49] * 10;
                maandl = dcf_array[48] * 8 + dcf_array[47] * 4 + dcf_array[46] * 2 + dcf_array[45] * 1;
                maand = maandh +maandl;

//calculate year---------------------------------------------------------------------------------------
                jaarh = dcf_array[57] * 80 + dcf_array[56] * 40 + dcf_array[55] * 20 + dcf_array[54] * 10;
                jaarl = dcf_array[53] * 8 +dcf_array[52] * 4 + dcf_array[51] * 2 + dcf_array[50] * 1;
                jaar = jaarh+jaarl;

//calculate parity
                paritym = dcf_array[21] + dcf_array[22] + dcf_array[23] + dcf_array[24] + dcf_array[25] + dcf_array[26] +dcf_array[27] +dcf_array [28];
                parityu =dcf_array[29] + dcf_array[30] + dcf_array[31] + dcf_array[32] + dcf_array[33] + dcf_array[34] + dcf_array[35];
                paritydmy =dcf_array[36] + dcf_array [37] + dcf_array [38] + dcf_array [39] + dcf_array[40] + dcf_array[41] + dcf_array [42] + dcf_array [43] + dcf_array[44] + dcf_array [45] + dcf_array[46] + dcf_array [47] + dcf_array[48] + dcf_array[49] + dcf_array[50] + dcf_array[51] + dcf_array [52] + dcf_array[53] + dcf_array[54] + dcf_array[55] + dcf_array[56] + dcf_array[57] + dcf_array[58];

//test parity------------------------------
                testu=parityu & 1;
                testm=paritym & 1;
                testdmy=paritydmy &1;

                lcd_txt();

            }//ed 3e while_loop

        }//end_2eWhile_loop

    }// end_1eWhile_loop

}//end main_programm
//============================================================================

//START makro syc
void sync () {
    loop_i=0;
    while (loop_i<20) {
        if (dcf_in==0) {
            loop_i++;
            wait (0.050);
        } else {
            loop_i=0;
        }
    }
}// end makro syc
//====================================================================

//STRART makro getbit

void getbit () {

    sign_bit_0 = 0;
    sign_bit_1 = 0;

    while (dcf_in==0);
    wait (0.150);

    if (dcf_in==0) {
        sign_bit_0=1;
        sign_bit_1=0;
        bit=0;
    } else {
        sign_bit_1=1;
        sign_bit_0=0;
        bit=1;
    }

    while (dcf_in) ;

    sec++;

    if (sec==61) {
        sec=1;
    }

    dcf_array[sec]=bit;



}//end makro getbit
//=========================================================

//START makro LCD++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void lcd_txt () {
    //wait for syncronize


    if (wait_sync==120)
     {
     wait_balk=0;
        lcd.cls();
    }
    if (wait_sync > 0)     {
    
        lcd.locate (0,3);
        lcd.printf("DCF syncronize  ");
        lcd.locate (0,5);
        lcd.printf("in:");
        lcd.printf("%dsec",wait_sync);
        wait_sync=wait_sync-1;
        wait_balk=wait_balk+1;
        lcd.fill(1,80,wait_balk,20,0xFF0000);
       

        if (wait_sync==99) {
            lcd.cls();
        }
        if (wait_sync==9) {
            lcd.cls();
        }
        if (wait_sync==0) {
            lcd.cls();
        }
    }    //end wait for syncronize

    if (wait_sync==0) {
        parall= testu or testm or testdmy;
        if (parall) {
            lcd.cls();
            lcd.printf("signal ERROR");
        }
        if (parall==0) {
            if (lcd_sec==59) lcd.cls();
            pc.printf("\x1B\x4A");
            lcd.locate(0,3);
            lcd.foreground (0xFFFFFF);
//summer/wintertime ZT or WT
            if (summertime==0) {
                lcd.printf("WT ");
                pc.printf(" Wintertime ");
            } else {
                lcd.printf("ZT ");
                pc.printf(" Summertime ");
            }

// UUR---------------------------------------------
            lcd.printf("%d:",uur);
            pc.printf("%d:",uur);

//MIN----------------------------------------------
            if (min<10) lcd.printf("0");
            lcd.printf("%d:",min);
            pc.printf("%d:",min);

//SEC----------------------------------------------
            lcd_sec=sec;
            if (lcd_sec==60)lcd_sec=0;
            if (lcd_sec<10) {
                lcd.printf("0");
                pc.printf("0");
            }
            lcd.printf("%d",lcd_sec);
            pc.printf("%d ",lcd_sec);
//LCD col=0 row=1----------------------------------
            lcd.locate(0,5);//nieuwe regel


//week Dag----------------------------------------------
            name_weekdag();
//Dag-----------------------------------
            lcd.printf(" %d ",dag);
            pc.printf(" %d ",dag);
//MONTH----------------------------------
            name_month();
//YEAR-------------------------------------------------------------------------------
            lcd.locate (5,10);
            lcd.printf(" 20");
            lcd.printf("%d",jaar);
            pc.printf(" 20");
            pc.printf("%d\r",jaar);


        }


    }//end if parall
}//end if  wait syncronize


//end MAKRO lcd++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//START MAKRO NAME_Week dag-----------------------------------------
void name_weekdag() {

    switch (w_dag) {
        case 1: {
            lcd.printf("Maandag");
            pc.printf("Ma");
            break;
        }

        case 2: {
            lcd.printf("Dinsdag");
            pc.printf("Di");
            break;
        }

        case 3: {
            lcd.printf("Woensdag");
            pc.printf("Wo");
            break;
        }

        case 4: {
            lcd.printf("Donderdag");
            pc.printf("Do");
            break;
        }

        case 5: {
            lcd.printf("Vrijdag");
            pc.printf("Vr");
            break;
        }

        case 6: {
            lcd.printf("Zaterdag");
            pc.printf("Za");
            break;
        }

        case 7: {
            lcd.foreground (0xFF0000);//rood
            lcd.printf("Zondag");
            pc.printf("Zo");
            break;
        }
    }

    lcd.locate (0,7);
}

//END name_weekday--------------------------------------------------------------------------

//start makro name_month-------------------------------------------------------------------
void name_month () {

    lcd.foreground (0xFFFFFF); //wit

    switch (maand) {
        case 1: {
            lcd.printf("Januari");
            pc.printf("Jan");
            break;
        }

        case 2: {
            lcd.printf("Februari");
            pc.printf("Feb");
            break;
        }

        case 3: {
            lcd.printf("Maart");
            pc.printf("Mrt");
            break;
        }

        case 4: {
            lcd.printf("April");
            pc.printf("Apr");
            break;
        }

        case 5: {
            lcd.printf("Mei");
            pc.printf("Mei");
            break;
        }

        case 6: {
            lcd.printf("Juni");
            pc.printf("Jun");
            break;
        }

        case 7: {
            lcd.printf("Juli");
            pc.printf("Jul");
            break;
        }

        case 8: {
            lcd.printf("Augustus");
            pc.printf("Aug");
            break;
        }

        case 9: {
            lcd.printf("September");
            pc.printf("Sep");


            break;
        }

        case 10: {
            lcd.printf("Oktober");
            pc.printf("Okt");
            break;
        }

        case 11: {
            lcd.printf("November");
            pc.printf("Nov");
            break;
        }

        case 12: {
            lcd.printf("December");
            pc.printf("Dec");
            break;
        }

    }

}
//end MAKRO name_month-------------------------------------------------------------------------------

