#include "mbed.h"
#include <string>

#include "QEI.h"

class Motor{
    
public:
    /** Constructor
    *   Create a motor object 
    *   
    *   @param in1 TB6612 IN1 pin number
    *   @param in2 TB6612 IN2 pin number
    *   @param pwm TB6612 PWM pin number
    */
    Motor(PinName in1, PinName in2, PinName pwm);
    
    /** Stop the motor
    *
    */
    void stop();  
    
    /** Set the speed
    *
    *   @param speed value to set
    */
    void setSpeed(float speed);
    
    
    void Motor::move(int in1, int in2);

private:
    DigitalOut in1;
    DigitalOut in2;
    PwmOut pwm;
};