#include "mbed.h"
#include <string>

#include "Motor.h"
#include "QEI.h"

///////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////
Motor::Motor(PinName in1, PinName in2, PinName pwm)
: in1(in1), in2(in2), pwm(pwm)
{
    this->pwm.period_ms(10);
}

///////////////////////////////////////////////////////////////////
// Public methods
///////////////////////////////////////////////////////////////////
void Motor::setSpeed(float speed)
{
    pwm.write(speed);
}

void Motor::stop()
{
    setSpeed(0);
}

void Motor::move(int in1, int in2)
{
    this->in1 = in1; 
    this->in2 = in2;  
}