//  Programa para enviar desde la FRDMKL25Z un mensaje de texto en formatp PDU
//   Como modem usa un celular SIEMENS a56i
//   ENVIAR -----la palabra "ALARMA 1"
//  

//   OJO CON ESTO
//   conector del siemens cable verde es RX conectelo a PTE0  cable blanco es TX conectelo a PTE1
#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
DebouncedIn button1(PTC11);  //Envio de msn
Serial GSM(PTE0,PTE1); //Configuracion de UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);//Configuracion USB a la consola serial del PC conectado.
void Rx_interrupt();
int position=0;
int lenpack=6;
int longi=0;
char tel[10];
char DE[50];
char buffer[512];
char buffermsg[72];
char buffer1[13];
char mensaje[100];
char NUMBER[13];    
int index;
int count;
int i = 0;
int c=0;
int cont=0;
unsigned char CtrlZ = 0x1A; 
bool Flag = false; //flag 
char r[]=""; //Cadena de recepcion de la trama PDU si se usa!!
char msg[256];
char char1;
//Flush serial para el buffer
void FlushGSM(void) { 
char1 = 0;
 while (GSM.readable()){
     char1 = GSM.getc();}
     return;}

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc.printf("%c\n", GSM.getc());
    
}
 
int readBuffer(char *buffer,int count)
{
    int i=0; 
    t.start();  
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.2);
    while(GSM.readable()) {  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}

/* esta funcion de abajo limpia o borra todo un "buffer" de tamaño "count"
lo revisa uno por un elemento y le mete el caracter null que indica fin de cadena
no retorna nada
*/
//***************************************************************************************
void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
/* esta funcion de abajo envia un comando parametrizado como cadena
*/
//***************************************************************************************
void sendCmd(char *cmd)
{
    GSM.puts(cmd);
}
/* esta funcion de abajo espera la respuesta de un comando que debe ser identica a la cadena "resp" y un tiempo timeout"
si todo sale bien retorna un cero que en la programacion hay que validar
si algo sale mal ( no se parece o se demora mucho )retorna -1 que debera validarse con alguna expresion logica
*/
//***************************************************************************************
int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    t.start();

    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }

    return 0;
}
/* esta funcion de abajo es muy completa e util se encarga de enviar el comando y esperar la respuesta
si todo sale bien retorna un cero(herencia de las funciones contenedoras) que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
/* esta funcion de abajo chequea que el modem este vivo  envia AT y le contesta con OK y espera 2 segundos
*/
//***************************************************************************************
int powerCheck(void)// este comando se manda para verificar si el modem esta vivo o conectado
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
/* esta funcion de abajo chequea el estado de la sim card
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSIMStatus(void)
{
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer,30);
    while(count < 3) {
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) {
            break;
        }
        count++;
        wait(0.2);
    }

    if(count == 3) {
        return -1;
    }
    return 0;
}
/* esta funcion de abajo chequea la calidad de la señal
y si todo sale bien retorna cun el valor de señal util o un -1 si nop es aceptable, en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSignalStrength(void)
{
    char gprsBuffer[100];
    int index,count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3) {
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3) {
        return -1;
    }
    return index;
}

/* esta funcion de abajo inicaliza el modem se compone de un grupo de subfunciones ya definidas previamente
primero chequea que este vivo
segundo chequea el estado de la simcard
tercero chequea la intencidad de señal celular
cuarto aplica la configuracion
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int init()
{
    for(int i = 0; i < 3; i++){
        sendCmdAndWaitForResp("AT\r\n", "OK", 1);
        wait(0.5);
    }
    if(0 != checkSIMStatus()) {
        return -1;
    }
    if(checkSignalStrength()<1) {
        return -1;
    }
   
    GSM.attach(&Rx_interrupt, Serial::RxIrq);
    return 0;
}
/* esta funcion de abajo intenta leer un mensaje de texto en formato PDU o HEX
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int readSMSpdu(char *message, int index)
{
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0';
    }
    return 0;
}
/* esta funcion de abajo borra mensajes SMS del modem
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/

int deleteSMS(int index)
{
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}
//***0*********************************************************************************

// Interupt Routine to read in data from serial port
void Rx_interrupt(){
     }
     
int main(void)
       { 
       //NVIC_DisableIRQ(UART1_IRQn);       
       //apagamos los 3 leds
       LedVerde=1;
       LedRojo=1;
       LedAzul=1;
       lenpack=6;  //tamaño de "ALARMA"
       GSM.baud(9600);//configura los baudios de la FRDMKL25Z en 9600
       GSM.format(8,Serial::None,1); //configura el formato de los datos de la UART
       //configuro modem GSM
       GSM.printf("AT\r\n");
       wait(0.2);
       GSM.printf("AT+CNMI=1,1\r\n");
       wait(0.2);
       GSM.printf("AT+CMGF=0\r\n");
       wait(0.2);
       GSM.printf("ATE\r\n");
       wait(0.2);
       GSM.printf("CBST=0,0,1\r\n");
       wait(0.2);  
       LedVerde=0;  
       wait(1);
       LedVerde=1;   
      
      while(1){ 
      
       if (button1.falling()){
          LedVerde=0;
          //LedRojo=0;
          LedAzul=0;
          //wait(1);
          
       index=22;
       GSM.printf("AT+CMGS=%d\r\n",index);
       wait(0.2);
       GSM.printf("0011000A9113686977910000AA07E1319A5E779F01"); //Enviar Advertencia
       wait(0.2);
       GSM.putc((char)0x1A); //esto es controlZ   
       wait(2);
       //LedRojo=1;
       LedAzul=1;
       LedVerde=1;     //se apaga
       
       }  
      
       if (GSM.readable()) {
            readBuffer(buffer,100);
            pc.printf("buffer= %s\n\r ",buffer);
            pc.printf("buffer= %c  %c\n\r ",buffer[10],buffer[11]);
                if(buffer[67]=='A'){for(i=0;i<86;i++){
                 buffermsg[i]=buffer[i];}
                 //pc.printf("mensaje= %s\n\r ",buffermsg); 
                 //pc.printf("mensaje[72]= %c mensaje[73]=%c\n\r ",buffermsg[72],buffermsg[73]);        
                 buffer[67]='c';
                 }
                 
    if(buffer[10]=='S'&& buffer[11]=='M'){
             for(i=0;i<5;i++)
             {
             buffer1[i]=buffer[2+i];
             }
             pc.printf("buffer1= %s\n\r ",buffer1);         
             buffer[10]='c';
             buffer[11]='c';
             }
             
    if(buffer1[3]=='T'){
            pc.printf("AT+CMGL=0\n\r");
            wait(0.2);
            GSM.printf("AT+CMGL=0\r\n");
            buffer1[3]='p';
            }
            
            if(buffermsg[70]=='6' && buffermsg[71]=='F'){
            LedRojo=0;
            LedVerde=0;
            LedAzul=0;
            //wait(0.2);
                /*index=22;
                GSM.printf("AT+CMGS=%d\r\n",index);
                wait(0.2);
                GSM.printf("0011000A9113686977910000AA0A61F77C8C0EB3E96537"); //Enviar confirmacion
                wait(0.2);
                GSM.putc((char)0x1A);*/ //esto es controlZ}
        }
            if(buffermsg[70]=='6' && buffermsg[71]=='3'){
            LedRojo=1;
            LedVerde=1;
            LedAzul=1;
            //wait(0.2);
                /*index=22;
                GSM.printf("AT+CMGS=%d\r\n",index);
                wait(0.2);
                GSM.printf("0011000A9113686977910000AA0BE1FA7C3E4687D9F4B21B"); //Enviar confirmacion
                wait(0.2);
                GSM.putc((char)0x1A); //esto es controlZ}*/
            }

}
}
}