#include "mbed.h"
#include "TextLCD.h"
#include "math.h"

#define ID 0x25


DigitalOut led(p5);
DigitalIn BP1(p6);
DigitalIn BP2(p7);

AnalogIn Uu(p17);
AnalogIn Ui(p16);

Ticker echantillonnage;
Ticker envoie_trame;

TextLCD lcd(p21, p22, p23, p24, p25, p26,TextLCD::LCD20x4); // rs, e, d4-d7
Serial pc(USBTX, USBRX);
//Serial xbee(p13, p14); // (tx,rx) module XBee

float Un;
float Un_1;
float Aire;

float Un_i;
float Un_1_i;
float Aire_i;

float Aire_p;


int cpt_echant;
int cpt_trame;

float Ueff;
float Ieff;
float P;
float Pconso = 0;
int Pconso_int;

char Tab_trame[14];

//float Pconso_led;

void trame(){
    uint16_t trame_4 = Ueff*10;
    uint16_t trame_6 = Ieff*10;
    uint16_t trame_8 = P*10;
    uint32_t trame_10 = Pconso*10;
    char sum;
    
    Tab_trame[0] = 0x55;
    Tab_trame[1] = 0x55;            
    Tab_trame[2] = ID;           
    Tab_trame[3] = Ueff*10;
    Tab_trame[4] = trame_4 >> 8;
    Tab_trame[5] = Ieff*10;
    Tab_trame[6] = trame_6 >> 8;
    Tab_trame[7] = P*10;
    Tab_trame[8] = trame_8 >> 8;
    Tab_trame[9] = Pconso*10;
    Tab_trame[10] = trame_10 >> 8;
    Tab_trame[11] = trame_10 >> 16;
    Tab_trame[12] = trame_10 >> 24;
    for(int i = 1; i < 13; i++) { sum = sum + Tab_trame[i]; };  // calcul du check sum
    Tab_trame[13] = sum;            // Check sum       
    
    for(int i = 0; i < 14; i++) {// boucle d'envoi des trames
        
        pc.putc(Tab_trame[i]);
        wait(0.01);
        //pc.printf("%c\n",Tab_trame[i]);
    } 
    //pc.printf("\n\r");
}

//-----------------------calcul--------------------------------------
void echantillon(){
    
    if(cpt_echant == 0){
        Un_1 = 2*(Uu.read()-0.5);
        Un_1_i = 2*(Ui.read()-0.5);
        cpt_echant++;
    }
    
    if(cpt_echant > 0 && cpt_echant < 10000){
        //Un_1 = Un;             
        Un =2*( Uu.read()-0.5);   
        Un_i =2*( Ui.read()-0.5);
            
        Aire = Aire + ((Un_1*Un_1 + Un*Un)/2);
        Aire_i = Aire_i + ((Un_1_i*Un_1_i + Un_i*Un_i)/2);
        Aire_p = Aire_p + ((Un_1*Un_1_i + Un_i*Un)/2);
        
        Un_1 = Un; 
        Un_1_i = Un_i; 
        cpt_echant++;
    }
    
    if(cpt_echant == 10000){
        Ueff = 250*1.41421*sqrt(Aire/10000); //1.41421 = racine(2);
        Ieff = 5*1.41421*sqrt(Aire_i/10000);
        P = 1250*1.41421*sqrt(Aire_p/10000); //1250 = 2*250
        
        Aire=0;
        Aire_i = 0;
        Aire_p = 0;
        
        cpt_echant = 0;
        
        //calcul clignotement led
        Pconso = P + Pconso;
        Pconso_int = Pconso;
        
    }    
}
//-------------------------------------------------------------------


int main()
{
    echantillonnage.attach(&echantillon, 0.0001);
    envoie_trame.attach(&trame, 2);
    
    //pc.printf("un=%f\n\r",Uu.read()); 
    wait(1);
    while(1) {
        
        if((Pconso/3600) - (Pconso_int >=1)){//permet de faire clignoter la led
            //Pconso_led = 0;
            led = !led;
            wait(0.2);
            led = !led;
        }
        
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Ueff = %0.2f V\n", Ueff);
        
        lcd.locate(0, 1);
        lcd.printf("Ieff = %0.2f A\n", Ieff);
        
        lcd.locate(0, 2);
        lcd.printf("P = %0.2f W\n", P);
        
        lcd.locate(0, 3);
        lcd.printf("Pconso = %0.2f Wh\n", Pconso/(3600.0));
        
        //pc.printf("Ueff = %f\n\r", Ueff);
        //pc.printf("Ieff = %f\n\r", Ieff);
        //pc.printf("P = %f\n\r", P);
        wait(1);

    }
}
