#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832.h"

TCPServer Server(EthernetInterface eth);
EthernetInterface Connect(void);
void ReceiveData(TCPSocket client);
void PrintData(void);
DigitalOut led(LED1);
C12832 lcd(D11, D13, D12, D7, D10);


float temp = 0;
char pwm =' ';
char senderID = ' ';

int main()
{
    
    printf("Server example\n\r");
    EthernetInterface eth = Connect();
    TCPServer srv = Server(eth);
    
while(true){
        
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &client_addr);
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
                    client_addr.get_port());
                    
                    
                    
        ReceiveData(client);
        client.send(buffer, 256);
        PrintData();
        client.close();
        
    }
}
void PrintData(void){
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.1f\n", temp);
        lcd.printf("PWM = %d\n", pwm);
        lcd.printf("ID Sender = %d\n", senderID);
    }

void ReceiveData(TCPSocket client){
        char data[4];
        client.recv(data, sizeof data);
        float temp = float((data[0]<<8)|data[1]) / 256.0;
        char pwm = data[2];
        char senderID = data[3];
        printf("The temperature is: %f\r\n", temp);
        printf("The PWM value is: %d\r\n", pwm);
        printf("The ID from the sender is: %d\r\n", senderID);
    }

EthernetInterface Connect(void){
            EthernetInterface eth;
            eth.set_network("192.168.0.10","255.255.255.0","192.168.0.1");
            eth.connect();
            printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
            return eth;
            }
            
TCPServer Server(EthernetInterface eth){
            TCPServer srv(&eth);
            srv.bind(4000);
            srv.listen();
            return srv;
            }

        
        