#include "mbed.h"
#include "EPD_GDE021A1.h"

#define EPD_CS       PA_15
#define EPD_DC       PB_11
#define EPD_RESET    PB_2
#define EPD_BUSY     PA_8
#define EPD_POWER    PB_10
#define EPD_SPI_MOSI PB_5
#define EPD_SPI_MISO PB_4
#define EPD_SPI_SCK  PB_3

EPD_GDE021A1 epd(EPD_CS, EPD_DC, EPD_RESET, EPD_BUSY, EPD_POWER, EPD_SPI_MOSI, EPD_SPI_MISO, EPD_SPI_SCK);

DigitalOut led1(LED1);
AnalogIn temperature(ADC_TEMP);
AnalogIn vref(ADC_VREF);
//width 48
//height 26
static uint8_t Battery_img[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0xff, 0x39, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

int main()
{
    led1 = 1;
    char tmpTemp[15] = "test";
    char string1[15];
    epd.SetFont(&Font20);
    epd.Clear(EPD_COLOR_WHITE);  
//    epd.DisplayStringAtLine(5, (uint8_t*)"HUEMBED", CENTER_MODE);
//    epd.DisplayStringAtLine(2, (uint8_t*)"demo", LEFT_MODE);
//    epd.DrawImage(130, 0, 48, 26, Battery_img);
//    epd.DrawRect(50, 4, 60, 4);
//    epd.RefreshDisplay();
    wait(2);
    float i = 10.3;
    while(1) {
        
        led1 = !led1;
        epd.Clear(EPD_COLOR_WHITE); 
        sprintf(tmpTemp, "P = %.1f", vref);
        sprintf(string1, "IDLE    %.1fV", vref.read());
        epd.DisplayStringAtLine(0, (uint8_t*)tmpTemp, LEFT_MODE);
        epd.DisplayStringAtLine(1, (uint8_t*)"0.5      1.0", LEFT_MODE);
        epd.DisplayStringAtLine(2, (uint8_t*)string1, LEFT_MODE);
        //epd.DrawImage(130, 0, 48, 26, Battery_img);
        //epd.DisplayChar(1, 3, (uint8_t*)"HUEMBED");
        epd.RefreshDisplay();
        i++;
        wait(2);
    }
}
