#include "mbed.h"
#include "FastPWM.h"

//PwmOut masterClock(PB_4);
FastPWM masterClock(PB_4,1);
DigitalOut shiftGate(PB_8);
//FastPWM shiftGate(PB_8,1);
//InterruptIn shiftGate_int(PC_6);
InterruptIn masterClock_int(PB_14);
//DigitalOut masterClock(PB_4);
//DigitalOut shiftGate(PB_8);
//InterruptIn shiftGate_int(PC_6);
DigitalOut ICG(PB_3);
AnalogIn imageIn(A0);
DigitalOut LED(LED1);
DigitalOut illuminator(PA_8);
DigitalOut blueLED(PB_5);
DigitalOut redLED(PB_10);
Serial raspi(USBTX, USBRX);

DigitalOut readOutIndicator(PC_3);
DigitalOut leadingDummyIndicator(PC_2);
DigitalOut trailingDummyIndicator(PH_1);

Ticker masterClock_HB;
Ticker dumpState;
bool masterClock_bool;
bool masterClock_engaged;
int masterClock_count;

// Calculate the corresponding acquisition measure for a given value in mV
#define MV(x) ((0xFFF*x)/3300)

float firmwareVersion = 0.2;

float masterClock_period                 = 86;    //microseconds
float  masterClock_width                 = 43;    //microseconds
//float masterFreq_period     = 20;    //microseconds
//int masterFreq_width        = 10;    //microseconds
int shiftGate_period        = 6;    //microseconds
int shiftGate_width         = 3;    //microseconds

double imageData;
const int integrationTime           = 147000;
//const int pixelTotal              = 3694;
//const int leadingDummyElements    = 16;
//const int leadShieldedElements    = 13;
//const int headerElements          = 3;
//const int totalLeadingDummy       = 32;
const int signalElements          = 3648;
//const int trailingDummyElements   = 14;
int pixelCount;
int readOutTrigger;
int dumpTrigger;
bool imageTrigger;
int state;
int readFlag;
double pixelValue[signalElements] = { 0 };

#define readOut_startUp             10
#define readOut_Begin               1
#define readOut_ACTIVE              2
#define readOut_LeadingDummy        3
#define readOut_LeadingShielded     4
#define readOut_headerElements      5
#define readOut_signalElements      6
#define readOut_trailingDummy       7
#define readOut_integrationTime     8
#define readOut_IDLE                9
#define readOut_Finish              0

void dumpImage(){
    if (dumpTrigger == 1){
        for (int pixelNumber=0; pixelNumber<signalElements; pixelNumber++) {
                raspi.printf("%i\t%4.12f\r\n", pixelNumber, 5 - ((pixelValue[pixelNumber - 1] / 5) / 4096.0));
        }
        dumpTrigger = 0;
    }
}
int shiftPulse;
void readOut(){
    blueLED = 1;
    pixelCount++;
    shiftPulse++;
//    if (shiftPulse == 10){
        shiftGate = !shiftGate;
//        shiftPulse = 0;
//    }
    pixelValue[pixelCount] = imageIn.read_u16();
//    blueLED = 0;
}

void init(){
    imageTrigger = false;
    shiftPulse = 0;
    dumpTrigger = 0;
    redLED = 1;
    readOutIndicator = 0;
    leadingDummyIndicator = 0;
    trailingDummyIndicator = 0;
    readFlag = 0;
    shiftGate = 0;
    ICG = 1;
//    masterClock_HB.attach_us(&masterClock_tick, masterFreq_period);
    pixelCount = 0;
    readOutTrigger = 0;
    state = readOut_startUp;
    pixelCount = 0;
    masterClock_count = 0;
    illuminator = 0;
}

void masterClock_tick(){
    if (masterClock_engaged == true){
        blueLED = 0;
//        masterClock = masterClock_bool;
        masterClock_bool = !masterClock_bool;
        switch (masterClock_count) {
            case 0:
                redLED = 1;
                shiftGate = 1;
                ICG = 0;
                break;
            case 100:
                shiftGate = 0;
                break;
            case 200:
                ICG = 1;
                leadingDummyIndicator = 1;
                break;
            case 232:
                leadingDummyIndicator = 0;
                readOutIndicator = 1;
                readFlag = 1;
                break;
            case 3880:
                trailingDummyIndicator = 1;
                readOutIndicator = 0;
                readFlag = 0;
                break;
            case 3894:
                trailingDummyIndicator = 0;
                shiftGate = 0;
                ICG = 0;
                break;
            case 3994:
                shiftGate = 0;
                break;
            case 4194:
                ICG = 1;
                shiftGate = 1;
                break;
            case 4294:
                redLED = 0;
                break;
            case 5000:
                init();
//                masterClock_engaged = false;
//                dumpTrigger = 1;
                shiftGate = 0;
                masterClock_count = -1;            
                redLED = 0;
                return;
            default:
                break;
        }
        if (readFlag == 1){
            readOut();
        }
        masterClock_count++;
    }
}

void printInfo(){
    raspi.printf("meridianScientific\r\n");
    raspi.printf("ramanPi - The DIY 3D Printable RaspberryPi Raman Spectrometer\r\n");
    raspi.printf("Spectrometer imagingBoard\r\n");
    raspi.printf("-------------------------------------------------------------\r\n");
    raspi.printf("Firmware Version: %f\r\n",firmwareVersion);
    raspi.printf("Current Sensitivity: %d\r\n", integrationTime);
}

int main(){
    init();
    wait(2);
    redLED = 0;

    dumpState.attach_us(&dumpImage, 50);
//    masterClock.period_us(masterFreq_period);
//    masterClock.pulsewidth_us(masterFreq_width);

    masterClock.prescaler(1);
    masterClock.period_ticks (masterClock_period);
    masterClock.pulsewidth_ticks(masterClock_width); 
    masterClock_int.rise(masterClock_tick);
        
                masterClock_engaged = true;  
    raspi.baud(921600);
    blueLED = 1;
    while(1) {
        char c = raspi.getc();
        switch (c) {
            case 'r':
                illuminator = 1;
//                masterClock_HB.attach_us(&masterClock_tick, masterFreq_period);     
                masterClock_engaged = true;  
                wait_us(100);
                imageTrigger = true;
                blueLED=1;         
                break;
            case 'l':
//                sensitivity = low;
                break;
            case 'v':
//                sensitivity = veryLow;
                break;
            case 'n':
//                sensitivity = mediumLow;
                break;
            case 'm':
//                sensitivity = medium;
                break;
            case 'h':
//                sensitivity = high;
                break;
            case 'c':
//                sensitivity = veryHigh;
                break;
            case 'i':
                printInfo();
                break;
            default:
                break;
        }
    }
}