#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "SNIC_Core.h"
#include "WebSocketServer.h"
#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
#endif

#define SSID        "wotxwot"
#define SEC_TYPE    e_SEC_WPA2_AES
#define SEC_KEY     "wotpasswd"

// tx, rx, cts, rts, reset, alarm=NC, baud=115200
C_SNIC_WifiInterface wifi(p9, p10, NC, NC, p30);

int main() {
#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif
    int ret = 0;

    printf("connecting wifi\r\n");

    ret = wifi.init();
    if (ret != 0) {
        printf("ERROR: Failed to init wifi %d\r\n", ret);
        return 1;
    }
    wait(0.5);
    
    ret = wifi.disconnect();
    if (ret != 0) {
        printf("ERROR: Failed to disconnect wifi %d\r\n", ret);
        return 1;
    }
    wait(0.3);

    wifi.connect(SSID, strlen(SSID), SEC_TYPE, SEC_KEY, strlen(SEC_KEY));
    if (ret != 0) {
        printf("ERROR: Failed to connect wifi %d\r\n", ret);
        return 1;
    }
    wait(0.5);

    wifi.setIPConfig(true);
    wait(0.5);

    printf("WiFi connected: %s\r\n", wifi.getIPAddress());

    WebSocketServer server;

    if (!server.init(80)) {
        printf("Failed to init server\r\n");
        return 1;
    }

    server.run();
}

