#ifndef _WEB_SOCKET_SERVER_H_
#define _WEB_SOCKET_SERVER_H_

#include "TCPSocketServer.h"

class WebSocketHandler
{
public:
    virtual void onOpen() = 0;
    virtual void onClose() = 0;
    virtual void onMessage() = 0;
    virtual void onError() = 0;
};

class WebSocketServer
{
public:
    WebSocketServer();
    virtual ~WebSocketServer();

    bool init(int port);
    void run();
    bool setHandler(const char* path, WebSocketHandler* handler);

private:
    bool handleHTTP(char* buf, int size);
    bool handleWebSocket(char* buf, int size);
    TCPSocketServer mTCPSocketServer;
};

#endif