#include "WebSocketServer.h"

WebSocketServer::WebSocketServer() {
}

WebSocketServer::~WebSocketServer() {
}

bool WebSocketServer::init(int port) {
	mTCPSocketServer.set_blocking(true);

	int ret = mTCPSocketServer.bind(port);
	if (ret != 0) {
		printf("ERROR: Failed to bind %d\r\n", ret);
		return false;
	}
	ret = mTCPSocketServer.listen();
	if (ret != 0) {
		printf("ERROR: Failed to listen %d\r\n", ret);
		return false;
	}

	return true;
}

void WebSocketServer::run() {
	TCPSocketConnection connection;
	char buf[1024];

	while (true) {
		bool isWebSocket = false;
		int ret = mTCPSocketServer.accept(connection);
		if (ret != 0) {
			continue;
		}
		printf("New connection\r\n");
		while (connection.is_connected()) {
			ret = connection.receive(buf, sizeof(buf) - 1);
			if (ret <= 0) {
				if (ret == 0) {
					printf("closed\r\n");
				} else {
					printf("ERROR: Failed to receive %d\r\n", ret);
				}
				break;
			}
			if (!isWebSocket) {
				if (this->handleHTTP(buf, ret)) {
					isWebSocket = true;
				} else {
					printf("ERROR: Non websocket\r\n");
					break;
				}
			} else {
				if (!this->handleWebSocket(buf, ret)) {
					break;
				}
			}
		}
		connection.close();
	}
}

bool WebSocketServer::setHandler(const char* path, WebSocketHandler* handler) {
	return true;
}

bool WebSocketServer::handleHTTP(char* buf, int size) {
	char* line = &buf[0];

	for (int i = 0; i < size; i++) {
		if (buf[i] == '\r' && i+1 < size && buf[i+1] == '\n') {
			buf[i] = '\0';
			if (strlen(buf) <= 0) {
				break;
			}
			printf("%s\r\n", line);
			i += 2;
			line = &buf[i];
		}
	}

	return true;
}

bool WebSocketServer::handleWebSocket(char* buf, int size) {
	return true;
}
