#ifndef _WEB_SOCKET_CONNECTION_H_
#define _WEB_SOCKET_CONNECTION_H_

#include "TCPSocketServer.h"
#include "WebSocketHandler.h"
#include <string>
#include <map>

class WebSocketServer;

class WebSocketConnection
{
public:
    WebSocketConnection(WebSocketServer* server);
    virtual ~WebSocketConnection();

    void run();
    TCPSocketConnection& getTCPSocketConnection() { return mConnection; }

private:
    bool handleHTTP(char* buf, int size);
    bool handleWebSocket(char* buf, int size);
    bool sendUpgradeResponse(char* key);

    WebSocketServer* mServer;
    TCPSocketConnection mConnection;
    WebSocketHandler* mHandler;
    bool mPrevFin;
};

#endif
